/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.deps.kubernetes.api.model.BaseKubernetesListFluent;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.openshift.api.model.RouteFluent;
import io.dekorate.deps.openshift.api.model.RouteSpecFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Ports;
import java.util.Optional;

@Description(value="Add a route to the list.")
public class AddRouteDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final OpenshiftConfig config;

    public AddRouteDecorator(OpenshiftConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        Optional p = Ports.getHttpPort((BaseConfig)this.config);
        if (!p.isPresent() || !this.config.isExpose()) {
            return;
        }
        Port port = (Port)p.get();
        ((BaseKubernetesListFluent.RouteItemsNested)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((BaseKubernetesListFluent.RouteItemsNested)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)list.addNewRouteItem().withNewMetadata().withName(this.config.getName())).withLabels(Labels.createLabels((BaseConfig)this.config))).endMetadata()).withNewSpec().withHost(this.config.getHost())).withPath(port.getPath())).withNewTo().withKind("Service")).withName(this.config.getName())).endTo()).withNewPort().withNewTargetPort(Integer.valueOf(port.getContainerPort()))).endPort()).endSpec()).endRouteItem();
    }
}

