/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import java.util.Arrays;
import java.util.List;

@Description(value="Apply the number of replicas to the DeploymentConfigSpec.")
public class ApplyReplicasDecorator
extends NamedResourceDecorator<DeploymentConfigSpecFluent>
implements WithConfigReferences {
    private final int replicas;

    public ApplyReplicasDecorator(int replicas) {
        super(ANY);
        this.replicas = replicas;
    }

    public ApplyReplicasDecorator(String deploymentName, int replicas) {
        super(deploymentName);
        this.replicas = replicas;
    }

    public void andThenVisit(DeploymentConfigSpecFluent deploymentSpec, ObjectMeta resourceMeta) {
        if (this.replicas > 0) {
            deploymentSpec.withReplicas(Integer.valueOf(this.replicas));
        }
    }

    public List<ConfigReference> getConfigReferences() {
        return Arrays.asList(this.buildConfigReferenceReplicas());
    }

    private ConfigReference buildConfigReferenceReplicas() {
        String property = ConfigReference.generateConfigReferenceName((String)"replicas", (String[])new String[]{this.getName()});
        String jsonPath = "$.[?(@.kind == 'DeploymentConfig')].spec.replicas";
        if (!Strings.equals((String)this.getName(), (String)ANY)) {
            jsonPath = "$.[?(@.kind == 'DeploymentConfig' && @.metadata.name == '" + this.getName() + "')].spec.replicas";
        }
        return new ConfigReference(property, jsonPath, (Object)this.replicas);
    }
}

