/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.util.Optional;

@Description(value="Add a route to the list.")
public class AddRouteDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final OpenshiftConfig config;

    public AddRouteDecorator(OpenshiftConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        if (!this.config.getRoute().isExpose()) {
            return;
        }
        Optional<Port> port = this.getNamedHttpPort(this.config);
        if (!port.isPresent()) {
            return;
        }
        if (this.contains(list, "route.openshift.io/v1", "Route", this.config.getName())) {
            return;
        }
        list.addToItems(new HasMetadata[]{((RouteBuilder)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(this.config.getName())).withLabels(Labels.createLabelsAsMap((BaseConfig)this.config, (String)"Route"))).endMetadata()).withNewSpec().withHost(this.config.getRoute().getHost())).withPath(port.get().getPath())).withNewTo().withKind("Service")).withName(this.config.getName())).endTo()).withNewPort().withNewTargetPort((Object)port.get().getName())).endPort()).endSpec()).build()});
    }

    private Optional<Port> getNamedHttpPort(OpenshiftConfig config) {
        String namedPortName = config.getRoute().getTargetPort();
        if (Strings.isNotNullOrEmpty((String)namedPortName)) {
            Optional port = Ports.getPortByFilter(p -> Strings.equals((String)p.getName(), (String)namedPortName), (BaseConfig)config);
            if (port.isPresent()) {
                return port;
            }
            return Optional.of(((PortBuilder)Port.newBuilder().withName(namedPortName)).build());
        }
        return Ports.getHttpPort((BaseConfig)config);
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddServiceResourceDecorator.class};
    }
}

