/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.AbstractKubernetesManifestGenerator;
import io.dekorate.ResourceFactory;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.utils.Images;
import io.dekorate.utils.Labels;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import java.util.stream.Collectors;

public class DeploymentConfigResourceFactory
implements ResourceFactory {
    private static final String KIND = "DeploymentConfig";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";

    public String kind() {
        return KIND;
    }

    public HasMetadata create(AbstractKubernetesManifestGenerator<?> generator, BaseConfig config) {
        return ((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(config.getName())).withLabels(Labels.createLabels((BaseConfig)config).stream().collect(Collectors.toMap(l -> l.getKey(), l -> l.getValue())))).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withTemplate(this.createPodTemplateSpec(generator, config))).endSpec()).build();
    }

    private PodTemplateSpec createPodTemplateSpec(AbstractKubernetesManifestGenerator<?> generator, BaseConfig config) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(this.createPodSpec(generator, config))).withNewMetadata().endMetadata()).build();
    }

    private PodSpec createPodSpec(AbstractKubernetesManifestGenerator<?> generator, BaseConfig config) {
        ImageConfiguration imageConfig = generator.getImageConfiguration(config);
        String image = Images.getImage((String)imageConfig.getRegistry(), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        return ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new PodSpecBuilder().addNewContainer().withName(config.getName())).withImage(image)).withImagePullPolicy(IF_NOT_PRESENT)).addNewEnv().withName(KUBERNETES_NAMESPACE)).withNewValueFrom().withNewFieldRef(null, METADATA_NAMESPACE)).endValueFrom()).endEnv()).endContainer()).build();
    }
}

