/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.CronJob;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.Job;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.openshift.config.OpenshiftConfigBuilder;
import io.dekorate.openshift.config.Route;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class OpenshiftConfig
extends BaseConfig {
    private Container[] initContainers = new Container[0];
    private Integer replicas;
    private Route route;
    private Boolean headless;

    public OpenshiftConfig() {
    }

    public OpenshiftConfig(Project project, Map<ConfigKey, Object> attributes, String partOf, String name, String version, String deploymentKind, Label[] labels, Annotation[] annotations, Env[] envVars, String workingDir, String[] command, String[] arguments, String serviceAccount, Port[] ports, ServiceType serviceType, PersistentVolumeClaimVolume[] pvcVolumes, SecretVolume[] secretVolumes, ConfigMapVolume[] configMapVolumes, EmptyDirVolume[] emptyDirVolumes, GitRepoVolume[] gitRepoVolumes, AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes, AzureDiskVolume[] azureDiskVolumes, AzureFileVolume[] azureFileVolumes, Mount[] mounts, ImagePullPolicy imagePullPolicy, String[] imagePullSecrets, DeploymentStrategy deploymentStrategy, RollingUpdate rollingUpdate, HostAlias[] hostAliases, Probe livenessProbe, Probe readinessProbe, Probe startupProbe, ResourceRequirements requestResources, ResourceRequirements limitResources, Container[] sidecars, Boolean autoDeployEnabled, Job[] jobs, CronJob[] cronJobs, Container[] initContainers, Integer replicas, Route route, Boolean headless) {
        super(project, attributes, partOf, name, version, deploymentKind, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, emptyDirVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, deploymentStrategy, rollingUpdate, hostAliases, livenessProbe, readinessProbe, startupProbe, requestResources, limitResources, sidecars, autoDeployEnabled, jobs, cronJobs);
        this.initContainers = initContainers != null ? initContainers : new Container[]{};
        this.replicas = replicas;
        this.route = route;
        this.headless = headless;
    }

    public Container[] getInitContainers() {
        return this.initContainers;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public Route getRoute() {
        return this.route;
    }

    public Boolean getHeadless() {
        return this.headless;
    }

    public boolean isHeadless() {
        return this.headless != null && this.headless != false;
    }

    public static OpenshiftConfigBuilder newOpenshiftConfigBuilder() {
        return new OpenshiftConfigBuilder();
    }

    public static OpenshiftConfigBuilder newOpenshiftConfigBuilderFromDefaults() {
        return (OpenshiftConfigBuilder)((OpenshiftConfigBuilder)((OpenshiftConfigBuilder)((OpenshiftConfigBuilder)((OpenshiftConfigBuilder)((OpenshiftConfigBuilder)((OpenshiftConfigBuilder)((OpenshiftConfigBuilder)new OpenshiftConfigBuilder().withDeploymentKind("DeploymentConfig")).withReplicas(1)).withDeploymentStrategy(DeploymentStrategy.None)).withServiceType(ServiceType.ClusterIP)).withImagePullPolicy(ImagePullPolicy.IfNotPresent)).withRoute(new Route())).withHeadless(false)).withAutoDeployEnabled(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenshiftConfig that = (OpenshiftConfig)((Object)o);
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.route != null ? !this.route.equals(that.route) : that.route != null) {
            return false;
        }
        return !(this.headless != null ? !this.headless.equals(that.headless) : that.headless != null);
    }

    public int hashCode() {
        return Objects.hash(this.initContainers, this.replicas, this.route, this.headless, super.hashCode());
    }
}

