/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.config.TLSConfig;
import io.dekorate.openshift.decorator.AddRouteDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.RouteSpecFluent;

@Description(value="Add the TLS configuration to the Route resource.")
public class AddTlsConfigToRouteDecorator
extends NamedResourceDecorator<RouteSpecFluent<?>> {
    private final OpenshiftConfig config;

    public AddTlsConfigToRouteDecorator(OpenshiftConfig config) {
        super("Route", config.getName());
        this.config = config;
    }

    public void andThenVisit(RouteSpecFluent<?> spec, ObjectMeta resourceMeta) {
        if (this.config.getRoute() == null || this.config.getRoute().getTls() == null || !this.anyFieldsSet(this.config.getRoute().getTls())) {
            return;
        }
        RouteSpecFluent.TlsNested tlsSpec = spec.editOrNewTls();
        TLSConfig tls = this.config.getRoute().getTls();
        if (Strings.isNotNullOrEmpty((String)tls.getCaCertificate())) {
            tlsSpec.withCaCertificate(tls.getCaCertificate());
        }
        if (Strings.isNotNullOrEmpty((String)tls.getCertificate())) {
            tlsSpec.withCertificate(tls.getCertificate());
        }
        if (Strings.isNotNullOrEmpty((String)tls.getKey())) {
            tlsSpec.withKey(tls.getKey());
        }
        if (Strings.isNotNullOrEmpty((String)tls.getDestinationCACertificate())) {
            tlsSpec.withDestinationCACertificate(tls.getDestinationCACertificate());
        }
        if (Strings.isNotNullOrEmpty((String)tls.getTermination())) {
            tlsSpec.withTermination(tls.getTermination());
        }
        if (Strings.isNotNullOrEmpty((String)tls.getInsecureEdgeTerminationPolicy())) {
            tlsSpec.withInsecureEdgeTerminationPolicy(tls.getInsecureEdgeTerminationPolicy());
        }
        tlsSpec.endTls();
    }

    private boolean anyFieldsSet(TLSConfig tls) {
        return Strings.isNotNullOrEmpty((String)tls.getCaCertificate()) || Strings.isNotNullOrEmpty((String)tls.getCertificate()) || Strings.isNotNullOrEmpty((String)tls.getKey()) || Strings.isNotNullOrEmpty((String)tls.getDestinationCACertificate()) || Strings.isNotNullOrEmpty((String)tls.getTermination()) || Strings.isNotNullOrEmpty((String)tls.getInsecureEdgeTerminationPolicy());
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddRouteDecorator.class};
    }
}

