/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent;

public class ApplyDeploymentConfigStrategyDecorator
extends NamedResourceDecorator<DeploymentConfigSpecFluent<?>> {
    private final DeploymentStrategy strategy;
    private final RollingUpdate rollingUpdate;

    public ApplyDeploymentConfigStrategyDecorator(String name, DeploymentStrategy strategy) {
        this(name, strategy, null);
    }

    public ApplyDeploymentConfigStrategyDecorator(String name, DeploymentStrategy strategy, RollingUpdate rollingUpdate) {
        super(name);
        this.strategy = strategy;
        this.rollingUpdate = rollingUpdate;
    }

    public void andThenVisit(DeploymentConfigSpecFluent<?> spec, ObjectMeta resourceMeta) {
        boolean hasCustomRollingUpdate = this.hasCustomRollingUpdateConfig(this.rollingUpdate);
        if (this.strategy == DeploymentStrategy.Recreate) {
            if (hasCustomRollingUpdate) {
                throw new IllegalStateException("Detected both Recreate strategy and custom Rolling Update config. Please use one or the other!");
            }
            ((DeploymentConfigSpecFluent.StrategyNested)spec.withNewStrategy().withType("Recreate")).endStrategy();
        } else if (this.strategy == DeploymentStrategy.RollingUpdate || hasCustomRollingUpdate) {
            ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RollingParamsNested)((RollingDeploymentStrategyParamsFluent.MaxUnavailableNested)((DeploymentStrategyFluent.RollingParamsNested)((RollingDeploymentStrategyParamsFluent.MaxSurgeNested)((DeploymentConfigSpecFluent.StrategyNested)spec.withNewStrategy().withType("RollingUpdate")).withNewRollingParams().withNewMaxSurge().withValue((Object)this.rollingUpdate.getMaxSurge())).endMaxSurge()).withNewMaxUnavailable().withValue((Object)this.rollingUpdate.getMaxUnavailable())).endMaxUnavailable()).endRollingParams()).endStrategy();
        }
    }

    private boolean hasCustomRollingUpdateConfig(RollingUpdate rollingUpdate) {
        return rollingUpdate != null && (!Strings.equals((String)rollingUpdate.getMaxUnavailable(), (String)"25%") || !Strings.equals((String)rollingUpdate.getMaxSurge(), (String)"25%"));
    }
}

