package io.dekorate.openshift.adapter;

import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.openshift.config.OpenshiftConfigBuilder;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.Item;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.annotation.CronJobConcurrencyPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import java.util.List;
import io.dekorate.kubernetes.annotation.JobRestartPolicy;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.config.Job;
import java.lang.Boolean;
import io.dekorate.openshift.config.Route;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import java.util.stream.Collectors;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.annotation.JobCompletionMode;
import io.dekorate.openshift.config.TLSConfig;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.HostAlias;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.openshift.annotation.OpenshiftApplication;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.CronJob;
import io.dekorate.project.BuildInfo;
import java.lang.Object;
import io.dekorate.project.ScmInfo;
import java.util.Arrays;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

/**
 * Generated
 */
public class OpenshiftConfigAdapter{
  
  
  
  public static OpenshiftConfig adapt(OpenshiftApplication instance) {
    return newBuilder(instance).build();
  }
  
  public static OpenshiftConfigBuilder newBuilder(OpenshiftApplication instance) {
    return new OpenshiftConfigBuilder(new OpenshiftConfig(null,
                null,
                instance.partOf(),
                instance.name(),
                instance.version(),
                instance.deploymentKind(),
                Arrays.asList(instance.labels()).stream().map(i ->new Label(i.key(),
                i.value(),
                i.kinds())).collect(Collectors.toList()).toArray(new Label[0]),
                Arrays.asList(instance.annotations()).stream().map(i ->new Annotation(i.key(),
                i.value(),
                i.kinds())).collect(Collectors.toList()).toArray(new Annotation[0]),
                Arrays.asList(instance.envVars()).stream().map(i ->new Env(i.name(),
                i.value(),
                i.secret(),
                i.configmap(),
                i.field(),
                i.resourceField())).collect(Collectors.toList()).toArray(new Env[0]),
                instance.workingDir(),
                instance.command(),
                instance.arguments(),
                instance.serviceAccount(),
                Arrays.asList(instance.ports()).stream().map(i ->new Port(i.name(),
                i.containerPort(),
                i.hostPort(),
                i.nodePort(),
                i.path(),
                i.protocol())).collect(Collectors.toList()).toArray(new Port[0]),
                instance.serviceType(),
                Arrays.asList(instance.pvcVolumes()).stream().map(i ->new PersistentVolumeClaimVolume(i.volumeName(),
                i.claimName(),
                i.readOnly())).collect(Collectors.toList()).toArray(new PersistentVolumeClaimVolume[0]),
                Arrays.asList(instance.secretVolumes()).stream().map(i ->new SecretVolume(i.volumeName(),
                i.secretName(),
                i.defaultMode(),
                i.optional(),
                Arrays.asList(i.items()).stream().map(j ->new Item(j.key(),
                j.path(),
                j.mode())).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new SecretVolume[0]),
                Arrays.asList(instance.configMapVolumes()).stream().map(i ->new ConfigMapVolume(i.volumeName(),
                i.configMapName(),
                i.defaultMode(),
                i.optional(),
                Arrays.asList(i.items()).stream().map(j ->new Item(j.key(),
                j.path(),
                j.mode())).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new ConfigMapVolume[0]),
                Arrays.asList(instance.emptyDirVolumes()).stream().map(i ->new EmptyDirVolume(i.volumeName())).collect(Collectors.toList()).toArray(new EmptyDirVolume[0]),
                Arrays.asList(instance.gitRepoVolumes()).stream().map(i ->new GitRepoVolume(i.volumeName(),
                i.repository(),
                i.directory(),
                i.revision())).collect(Collectors.toList()).toArray(new GitRepoVolume[0]),
                Arrays.asList(instance.awsElasticBlockStoreVolumes()).stream().map(i ->new AwsElasticBlockStoreVolume(i.volumeName(),
                i.volumeId(),
                i.partition(),
                i.fsType(),
                i.readOnly())).collect(Collectors.toList()).toArray(new AwsElasticBlockStoreVolume[0]),
                Arrays.asList(instance.azureDiskVolumes()).stream().map(i ->new AzureDiskVolume(i.volumeName(),
                i.diskName(),
                i.diskURI(),
                i.kind(),
                i.cachingMode(),
                i.fsType(),
                i.readOnly())).collect(Collectors.toList()).toArray(new AzureDiskVolume[0]),
                Arrays.asList(instance.azureFileVolumes()).stream().map(i ->new AzureFileVolume(i.volumeName(),
                i.shareName(),
                i.secretName(),
                i.readOnly())).collect(Collectors.toList()).toArray(new AzureFileVolume[0]),
                Arrays.asList(instance.mounts()).stream().map(i ->new Mount(i.name(),
                i.path(),
                i.subPath(),
                i.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]),
                instance.imagePullPolicy(),
                instance.imagePullSecrets(),
                instance.deploymentStrategy(),
                new RollingUpdate(instance.rollingUpdate().maxUnavailable(),
                instance.rollingUpdate().maxSurge()),
                null,
                new Probe(instance.livenessProbe().httpActionPath(),
                instance.livenessProbe().execAction(),
                instance.livenessProbe().tcpSocketAction(),
                instance.livenessProbe().grpcAction(),
                instance.livenessProbe().initialDelaySeconds(),
                instance.livenessProbe().periodSeconds(),
                instance.livenessProbe().timeoutSeconds(),
                instance.livenessProbe().successThreshold(),
                instance.livenessProbe().failureThreshold()),
                new Probe(instance.readinessProbe().httpActionPath(),
                instance.readinessProbe().execAction(),
                instance.readinessProbe().tcpSocketAction(),
                instance.readinessProbe().grpcAction(),
                instance.readinessProbe().initialDelaySeconds(),
                instance.readinessProbe().periodSeconds(),
                instance.readinessProbe().timeoutSeconds(),
                instance.readinessProbe().successThreshold(),
                instance.readinessProbe().failureThreshold()),
                new Probe(instance.startupProbe().httpActionPath(),
                instance.startupProbe().execAction(),
                instance.startupProbe().tcpSocketAction(),
                instance.startupProbe().grpcAction(),
                instance.startupProbe().initialDelaySeconds(),
                instance.startupProbe().periodSeconds(),
                instance.startupProbe().timeoutSeconds(),
                instance.startupProbe().successThreshold(),
                instance.startupProbe().failureThreshold()),
                new ResourceRequirements(instance.requestResources().memory(),
                instance.requestResources().cpu()),
                new ResourceRequirements(instance.limitResources().memory(),
                instance.limitResources().cpu()),
                Arrays.asList(instance.sidecars()).stream().map(i ->new Container(i.image(),
                i.name(),
                Arrays.asList(i.envVars()).stream().map(j ->new Env(j.name(),
                j.value(),
                j.secret(),
                j.configmap(),
                j.field(),
                j.resourceField())).collect(Collectors.toList()).toArray(new Env[0]),
                i.workingDir(),
                i.command(),
                i.arguments(),
                Arrays.asList(i.ports()).stream().map(j ->new Port(j.name(),
                j.containerPort(),
                j.hostPort(),
                j.nodePort(),
                j.path(),
                j.protocol())).collect(Collectors.toList()).toArray(new Port[0]),
                Arrays.asList(i.mounts()).stream().map(j ->new Mount(j.name(),
                j.path(),
                j.subPath(),
                j.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]),
                i.imagePullPolicy(),
                new Probe(i.livenessProbe().httpActionPath(),
                i.livenessProbe().execAction(),
                i.livenessProbe().tcpSocketAction(),
                i.livenessProbe().grpcAction(),
                i.livenessProbe().initialDelaySeconds(),
                i.livenessProbe().periodSeconds(),
                i.livenessProbe().timeoutSeconds(),
                i.livenessProbe().successThreshold(),
                i.livenessProbe().failureThreshold()),
                new Probe(i.readinessProbe().httpActionPath(),
                i.readinessProbe().execAction(),
                i.readinessProbe().tcpSocketAction(),
                i.readinessProbe().grpcAction(),
                i.readinessProbe().initialDelaySeconds(),
                i.readinessProbe().periodSeconds(),
                i.readinessProbe().timeoutSeconds(),
                i.readinessProbe().successThreshold(),
                i.readinessProbe().failureThreshold()),
                new Probe(i.startupProbe().httpActionPath(),
                i.startupProbe().execAction(),
                i.startupProbe().tcpSocketAction(),
                i.startupProbe().grpcAction(),
                i.startupProbe().initialDelaySeconds(),
                i.startupProbe().periodSeconds(),
                i.startupProbe().timeoutSeconds(),
                i.startupProbe().successThreshold(),
                i.startupProbe().failureThreshold()),
                new ResourceRequirements(i.requestResources().memory(),
                i.requestResources().cpu()),
                new ResourceRequirements(i.limitResources().memory(),
                i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]),
                instance.autoDeployEnabled(),
                Arrays.asList(instance.jobs()).stream().map(i ->new Job(i.name(),
                i.parallelism(),
                i.completions(),
                i.completionMode(),
                i.backoffLimit(),
                i.activeDeadlineSeconds(),
                i.ttlSecondsAfterFinished(),
                i.suspend(),
                i.restartPolicy(),
                Arrays.asList(i.pvcVolumes()).stream().map(j ->new PersistentVolumeClaimVolume(j.volumeName(),
                j.claimName(),
                j.readOnly())).collect(Collectors.toList()).toArray(new PersistentVolumeClaimVolume[0]),
                Arrays.asList(i.secretVolumes()).stream().map(j ->new SecretVolume(j.volumeName(),
                j.secretName(),
                j.defaultMode(),
                j.optional(),
                Arrays.asList(j.items()).stream().map(k ->new Item(k.key(),
                k.path(),
                k.mode())).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new SecretVolume[0]),
                Arrays.asList(i.configMapVolumes()).stream().map(j ->new ConfigMapVolume(j.volumeName(),
                j.configMapName(),
                j.defaultMode(),
                j.optional(),
                Arrays.asList(j.items()).stream().map(k ->new Item(k.key(),
                k.path(),
                k.mode())).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new ConfigMapVolume[0]),
                Arrays.asList(i.emptyDirVolumes()).stream().map(j ->new EmptyDirVolume(j.volumeName())).collect(Collectors.toList()).toArray(new EmptyDirVolume[0]),
                Arrays.asList(i.awsElasticBlockStoreVolumes()).stream().map(j ->new AwsElasticBlockStoreVolume(j.volumeName(),
                j.volumeId(),
                j.partition(),
                j.fsType(),
                j.readOnly())).collect(Collectors.toList()).toArray(new AwsElasticBlockStoreVolume[0]),
                Arrays.asList(i.azureDiskVolumes()).stream().map(j ->new AzureDiskVolume(j.volumeName(),
                j.diskName(),
                j.diskURI(),
                j.kind(),
                j.cachingMode(),
                j.fsType(),
                j.readOnly())).collect(Collectors.toList()).toArray(new AzureDiskVolume[0]),
                Arrays.asList(i.azureFileVolumes()).stream().map(j ->new AzureFileVolume(j.volumeName(),
                j.shareName(),
                j.secretName(),
                j.readOnly())).collect(Collectors.toList()).toArray(new AzureFileVolume[0]),
                Arrays.asList(i.containers()).stream().map(j ->new Container(j.image(),
                j.name(),
                Arrays.asList(j.envVars()).stream().map(k ->new Env(k.name(),
                k.value(),
                k.secret(),
                k.configmap(),
                k.field(),
                k.resourceField())).collect(Collectors.toList()).toArray(new Env[0]),
                j.workingDir(),
                j.command(),
                j.arguments(),
                Arrays.asList(j.ports()).stream().map(k ->new Port(k.name(),
                k.containerPort(),
                k.hostPort(),
                k.nodePort(),
                k.path(),
                k.protocol())).collect(Collectors.toList()).toArray(new Port[0]),
                Arrays.asList(j.mounts()).stream().map(k ->new Mount(k.name(),
                k.path(),
                k.subPath(),
                k.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]),
                j.imagePullPolicy(),
                new Probe(j.livenessProbe().httpActionPath(),
                j.livenessProbe().execAction(),
                j.livenessProbe().tcpSocketAction(),
                j.livenessProbe().grpcAction(),
                j.livenessProbe().initialDelaySeconds(),
                j.livenessProbe().periodSeconds(),
                j.livenessProbe().timeoutSeconds(),
                j.livenessProbe().successThreshold(),
                j.livenessProbe().failureThreshold()),
                new Probe(j.readinessProbe().httpActionPath(),
                j.readinessProbe().execAction(),
                j.readinessProbe().tcpSocketAction(),
                j.readinessProbe().grpcAction(),
                j.readinessProbe().initialDelaySeconds(),
                j.readinessProbe().periodSeconds(),
                j.readinessProbe().timeoutSeconds(),
                j.readinessProbe().successThreshold(),
                j.readinessProbe().failureThreshold()),
                new Probe(j.startupProbe().httpActionPath(),
                j.startupProbe().execAction(),
                j.startupProbe().tcpSocketAction(),
                j.startupProbe().grpcAction(),
                j.startupProbe().initialDelaySeconds(),
                j.startupProbe().periodSeconds(),
                j.startupProbe().timeoutSeconds(),
                j.startupProbe().successThreshold(),
                j.startupProbe().failureThreshold()),
                new ResourceRequirements(j.requestResources().memory(),
                j.requestResources().cpu()),
                new ResourceRequirements(j.limitResources().memory(),
                j.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]))).collect(Collectors.toList()).toArray(new Job[0]),
                Arrays.asList(instance.cronJobs()).stream().map(i ->new CronJob(i.name(),
                i.schedule(),
                i.concurrencyPolicy(),
                i.startingDeadlineSeconds(),
                i.failedJobsHistoryLimit(),
                i.successfulJobsHistoryLimit(),
                i.parallelism(),
                i.completions(),
                i.completionMode(),
                i.backoffLimit(),
                i.activeDeadlineSeconds(),
                i.ttlSecondsAfterFinished(),
                i.suspend(),
                i.restartPolicy(),
                Arrays.asList(i.pvcVolumes()).stream().map(j ->new PersistentVolumeClaimVolume(j.volumeName(),
                j.claimName(),
                j.readOnly())).collect(Collectors.toList()).toArray(new PersistentVolumeClaimVolume[0]),
                Arrays.asList(i.secretVolumes()).stream().map(j ->new SecretVolume(j.volumeName(),
                j.secretName(),
                j.defaultMode(),
                j.optional(),
                Arrays.asList(j.items()).stream().map(k ->new Item(k.key(),
                k.path(),
                k.mode())).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new SecretVolume[0]),
                Arrays.asList(i.configMapVolumes()).stream().map(j ->new ConfigMapVolume(j.volumeName(),
                j.configMapName(),
                j.defaultMode(),
                j.optional(),
                Arrays.asList(j.items()).stream().map(k ->new Item(k.key(),
                k.path(),
                k.mode())).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new ConfigMapVolume[0]),
                Arrays.asList(i.emptyDirVolumes()).stream().map(j ->new EmptyDirVolume(j.volumeName())).collect(Collectors.toList()).toArray(new EmptyDirVolume[0]),
                Arrays.asList(i.awsElasticBlockStoreVolumes()).stream().map(j ->new AwsElasticBlockStoreVolume(j.volumeName(),
                j.volumeId(),
                j.partition(),
                j.fsType(),
                j.readOnly())).collect(Collectors.toList()).toArray(new AwsElasticBlockStoreVolume[0]),
                Arrays.asList(i.azureDiskVolumes()).stream().map(j ->new AzureDiskVolume(j.volumeName(),
                j.diskName(),
                j.diskURI(),
                j.kind(),
                j.cachingMode(),
                j.fsType(),
                j.readOnly())).collect(Collectors.toList()).toArray(new AzureDiskVolume[0]),
                Arrays.asList(i.azureFileVolumes()).stream().map(j ->new AzureFileVolume(j.volumeName(),
                j.shareName(),
                j.secretName(),
                j.readOnly())).collect(Collectors.toList()).toArray(new AzureFileVolume[0]),
                Arrays.asList(i.containers()).stream().map(j ->new Container(j.image(),
                j.name(),
                Arrays.asList(j.envVars()).stream().map(k ->new Env(k.name(),
                k.value(),
                k.secret(),
                k.configmap(),
                k.field(),
                k.resourceField())).collect(Collectors.toList()).toArray(new Env[0]),
                j.workingDir(),
                j.command(),
                j.arguments(),
                Arrays.asList(j.ports()).stream().map(k ->new Port(k.name(),
                k.containerPort(),
                k.hostPort(),
                k.nodePort(),
                k.path(),
                k.protocol())).collect(Collectors.toList()).toArray(new Port[0]),
                Arrays.asList(j.mounts()).stream().map(k ->new Mount(k.name(),
                k.path(),
                k.subPath(),
                k.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]),
                j.imagePullPolicy(),
                new Probe(j.livenessProbe().httpActionPath(),
                j.livenessProbe().execAction(),
                j.livenessProbe().tcpSocketAction(),
                j.livenessProbe().grpcAction(),
                j.livenessProbe().initialDelaySeconds(),
                j.livenessProbe().periodSeconds(),
                j.livenessProbe().timeoutSeconds(),
                j.livenessProbe().successThreshold(),
                j.livenessProbe().failureThreshold()),
                new Probe(j.readinessProbe().httpActionPath(),
                j.readinessProbe().execAction(),
                j.readinessProbe().tcpSocketAction(),
                j.readinessProbe().grpcAction(),
                j.readinessProbe().initialDelaySeconds(),
                j.readinessProbe().periodSeconds(),
                j.readinessProbe().timeoutSeconds(),
                j.readinessProbe().successThreshold(),
                j.readinessProbe().failureThreshold()),
                new Probe(j.startupProbe().httpActionPath(),
                j.startupProbe().execAction(),
                j.startupProbe().tcpSocketAction(),
                j.startupProbe().grpcAction(),
                j.startupProbe().initialDelaySeconds(),
                j.startupProbe().periodSeconds(),
                j.startupProbe().timeoutSeconds(),
                j.startupProbe().successThreshold(),
                j.startupProbe().failureThreshold()),
                new ResourceRequirements(j.requestResources().memory(),
                j.requestResources().cpu()),
                new ResourceRequirements(j.limitResources().memory(),
                j.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]))).collect(Collectors.toList()).toArray(new CronJob[0]),
                Arrays.asList(instance.initContainers()).stream().map(i ->new Container(i.image(),
                i.name(),
                Arrays.asList(i.envVars()).stream().map(j ->new Env(j.name(),
                j.value(),
                j.secret(),
                j.configmap(),
                j.field(),
                j.resourceField())).collect(Collectors.toList()).toArray(new Env[0]),
                i.workingDir(),
                i.command(),
                i.arguments(),
                Arrays.asList(i.ports()).stream().map(j ->new Port(j.name(),
                j.containerPort(),
                j.hostPort(),
                j.nodePort(),
                j.path(),
                j.protocol())).collect(Collectors.toList()).toArray(new Port[0]),
                Arrays.asList(i.mounts()).stream().map(j ->new Mount(j.name(),
                j.path(),
                j.subPath(),
                j.readOnly())).collect(Collectors.toList()).toArray(new Mount[0]),
                i.imagePullPolicy(),
                new Probe(i.livenessProbe().httpActionPath(),
                i.livenessProbe().execAction(),
                i.livenessProbe().tcpSocketAction(),
                i.livenessProbe().grpcAction(),
                i.livenessProbe().initialDelaySeconds(),
                i.livenessProbe().periodSeconds(),
                i.livenessProbe().timeoutSeconds(),
                i.livenessProbe().successThreshold(),
                i.livenessProbe().failureThreshold()),
                new Probe(i.readinessProbe().httpActionPath(),
                i.readinessProbe().execAction(),
                i.readinessProbe().tcpSocketAction(),
                i.readinessProbe().grpcAction(),
                i.readinessProbe().initialDelaySeconds(),
                i.readinessProbe().periodSeconds(),
                i.readinessProbe().timeoutSeconds(),
                i.readinessProbe().successThreshold(),
                i.readinessProbe().failureThreshold()),
                new Probe(i.startupProbe().httpActionPath(),
                i.startupProbe().execAction(),
                i.startupProbe().tcpSocketAction(),
                i.startupProbe().grpcAction(),
                i.startupProbe().initialDelaySeconds(),
                i.startupProbe().periodSeconds(),
                i.startupProbe().timeoutSeconds(),
                i.startupProbe().successThreshold(),
                i.startupProbe().failureThreshold()),
                new ResourceRequirements(i.requestResources().memory(),
                i.requestResources().cpu()),
                new ResourceRequirements(i.limitResources().memory(),
                i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]),
                instance.replicas(),
                new Route(instance.route().expose(),
                instance.route().host(),
                instance.route().targetPort(),
                new TLSConfig(instance.route().tls().caCertificate(),
                instance.route().tls().certificate(),
                instance.route().tls().destinationCACertificate(),
                instance.route().tls().insecureEdgeTerminationPolicy(),
                instance.route().tls().key(),
                instance.route().tls().termination())),
                instance.headless()));
  }
  
  public static OpenshiftConfig adapt(Map map) {
    return new OpenshiftConfig(
    null,
    null,
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("partOf", null) : null),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("deploymentKind", null) : null),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("labels" , new Map[0]) : new Map[0])).map(i ->new Label(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
    i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new Label[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new Annotation(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
    i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new Annotation[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(i ->new Env(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("secret", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("field", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("workingDir", null) : null),
    map instanceof Map ? toStringArray(((Map)map).get("command")) : toStringArray(map),
    map instanceof Map ? toStringArray(((Map)map).get("arguments")) : toStringArray(map),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("serviceAccount", null) : null),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new Port(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("containerPort", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("hostPort", 0) : 0),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("nodePort", 0) : 0),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   (ServiceType)(map instanceof Map ? ( ((Map)map).getOrDefault("serviceType", null) != null ? io.dekorate.kubernetes.annotation.ServiceType.valueOf(String.valueOf(((Map)map).getOrDefault("serviceType", null))) : null ) : null),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(i ->new PersistentVolumeClaimVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("claimName", null) : null),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new PersistentVolumeClaimVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(i ->new SecretVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("items" , new Map[0]) : new Map[0])).map(j ->new Item(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("key", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new SecretVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(i ->new ConfigMapVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("configMapName", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("items" , new Map[0]) : new Map[0])).map(j ->new Item(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("key", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new ConfigMapVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("emptyDirVolumes" , new Map[0]) : new Map[0])).map(i ->new EmptyDirVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null))).toArray(size-> new EmptyDirVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("gitRepoVolumes" , new Map[0]) : new Map[0])).map(i ->new GitRepoVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("directory", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("revision", "") : ""))).toArray(size-> new GitRepoVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(i ->new AwsElasticBlockStoreVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeId", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("partition", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new AwsElasticBlockStoreVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(i ->new AzureDiskVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("diskName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("diskURI", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("kind", "Managed") : "Managed"),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureDiskVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(i ->new AzureFileVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("shareName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureFileVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(i ->new Mount(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("subPath", "") : ""),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   (ImagePullPolicy)(map instanceof Map ? ( ((Map)map).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)map).getOrDefault("imagePullPolicy", null))) : null ) : null),
    map instanceof Map ? toStringArray(((Map)map).get("imagePullSecrets")) : toStringArray(map),
                   (DeploymentStrategy)(map instanceof Map ? ( ((Map)map).getOrDefault("deploymentStrategy", null) != null ? io.dekorate.kubernetes.config.DeploymentStrategy.valueOf(String.valueOf(((Map)map).getOrDefault("deploymentStrategy", null))) : null ) : null),
    new RollingUpdate(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxUnavailable", "25%") : "25%"),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxSurge", "25%") : "25%")),
    null,
    new Probe(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("cpu", "") : "")),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("sidecars" , new Map[0]) : new Map[0])).map(i ->new Container(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new Env(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
    i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
    i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new Port(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", 0) : 0),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("nodePort", 0) : 0),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new Mount(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new Container[size]),
                   (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled", null) : null),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("jobs" , new Map[0]) : new Map[0])).map(i ->new Job(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("parallelism", -1) : -1),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("completions", -1) : -1),
                   io.dekorate.kubernetes.annotation.JobCompletionMode.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("completionMode","NonIndexed") : "NonIndexed")),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("backoffLimit", -1) : -1),
                   (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("activeDeadlineSeconds", -1L) : -1L),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("ttlSecondsAfterFinished", -1) : -1),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("suspend", false) : false),
                   io.dekorate.kubernetes.annotation.JobRestartPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("restartPolicy","OnFailure") : "OnFailure")),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(j ->new PersistentVolumeClaimVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("claimName", null) : null),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new PersistentVolumeClaimVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(j ->new SecretVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("items" , new Map[0]) : new Map[0])).map(k ->new Item(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("key", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new SecretVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(j ->new ConfigMapVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("configMapName", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("items" , new Map[0]) : new Map[0])).map(k ->new Item(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("key", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new ConfigMapVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("emptyDirVolumes" , new Map[0]) : new Map[0])).map(j ->new EmptyDirVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null))).toArray(size-> new EmptyDirVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(j ->new AwsElasticBlockStoreVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeId", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("partition", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AwsElasticBlockStoreVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(j ->new AzureDiskVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("diskName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("diskURI", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("kind", "Managed") : "Managed"),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureDiskVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(j ->new AzureFileVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("shareName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureFileVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("containers" , new Map[0]) : new Map[0])).map(j ->new Container(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("image", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", "") : ""),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(k ->new Env(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("value", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("secret", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("configmap", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("field", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("workingDir", "") : ""),
    j instanceof Map ? toStringArray(((Map)j).get("command")) : toStringArray(j),
    j instanceof Map ? toStringArray(((Map)j).get("arguments")) : toStringArray(j),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("ports" , new Map[0]) : new Map[0])).map(k ->new Port(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("containerPort", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("hostPort", 0) : 0),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("nodePort", 0) : 0),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(k instanceof Map ? ((Map)k).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(k ->new Mount(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("subPath", "") : ""),
                   (Boolean)(k instanceof Map ? ((Map)k).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new Container[size]))).toArray(size-> new Job[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("cronJobs" , new Map[0]) : new Map[0])).map(i ->new CronJob(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("schedule", null) : null),
                   io.dekorate.kubernetes.annotation.CronJobConcurrencyPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("concurrencyPolicy","Allow") : "Allow")),
                   (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("startingDeadlineSeconds", -1L) : -1L),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("failedJobsHistoryLimit", 1) : 1),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("successfulJobsHistoryLimit", 3) : 3),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("parallelism", -1) : -1),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("completions", -1) : -1),
                   io.dekorate.kubernetes.annotation.JobCompletionMode.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("completionMode","NonIndexed") : "NonIndexed")),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("backoffLimit", -1) : -1),
                   (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("activeDeadlineSeconds", -1L) : -1L),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("ttlSecondsAfterFinished", -1) : -1),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("suspend", false) : false),
                   io.dekorate.kubernetes.annotation.JobRestartPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("restartPolicy","OnFailure") : "OnFailure")),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(j ->new PersistentVolumeClaimVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("claimName", null) : null),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new PersistentVolumeClaimVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(j ->new SecretVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("items" , new Map[0]) : new Map[0])).map(k ->new Item(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("key", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new SecretVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(j ->new ConfigMapVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("configMapName", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("items" , new Map[0]) : new Map[0])).map(k ->new Item(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("key", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new ConfigMapVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("emptyDirVolumes" , new Map[0]) : new Map[0])).map(j ->new EmptyDirVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null))).toArray(size-> new EmptyDirVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(j ->new AwsElasticBlockStoreVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeId", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("partition", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AwsElasticBlockStoreVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(j ->new AzureDiskVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("diskName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("diskURI", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("kind", "Managed") : "Managed"),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureDiskVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(j ->new AzureFileVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("shareName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureFileVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("containers" , new Map[0]) : new Map[0])).map(j ->new Container(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("image", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", "") : ""),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(k ->new Env(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("value", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("secret", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("configmap", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("field", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("workingDir", "") : ""),
    j instanceof Map ? toStringArray(((Map)j).get("command")) : toStringArray(j),
    j instanceof Map ? toStringArray(((Map)j).get("arguments")) : toStringArray(j),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("ports" , new Map[0]) : new Map[0])).map(k ->new Port(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("containerPort", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("hostPort", 0) : 0),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("nodePort", 0) : 0),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(k instanceof Map ? ((Map)k).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(k ->new Mount(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("subPath", "") : ""),
                   (Boolean)(k instanceof Map ? ((Map)k).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new Container[size]))).toArray(size-> new CronJob[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("initContainers" , new Map[0]) : new Map[0])).map(i ->new Container(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new Env(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
    i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
    i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new Port(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", 0) : 0),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("nodePort", 0) : 0),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new Mount(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new Container[size]),
                   (Integer)(map instanceof Map ? ((Map)map).getOrDefault("replicas", null) : null),
    new Route(
                       (Boolean)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).getOrDefault("expose", false) : false),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).getOrDefault("host", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).getOrDefault("targetPort", "http") : "http"),
    new TLSConfig(
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("caCertificate", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("certificate", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("destinationCACertificate", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("insecureEdgeTerminationPolicy", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("key", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("termination", "") : ""))),
                   (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("headless", null) : null));
  }
  
  public static OpenshiftConfigBuilder newBuilder(Map map) {
    return new OpenshiftConfigBuilder(new OpenshiftConfig(
    null,
    null,
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("partOf", null) : null),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("deploymentKind", null) : null),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("labels" , new Map[0]) : new Map[0])).map(i ->new Label(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
    i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new Label[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new Annotation(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
    i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new Annotation[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(i ->new Env(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("secret", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("field", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("workingDir", null) : null),
    map instanceof Map ? toStringArray(((Map)map).get("command")) : toStringArray(map),
    map instanceof Map ? toStringArray(((Map)map).get("arguments")) : toStringArray(map),
                   (String)(map instanceof Map ? ((Map)map).getOrDefault("serviceAccount", null) : null),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new Port(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("containerPort", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("hostPort", 0) : 0),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("nodePort", 0) : 0),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   (ServiceType)(map instanceof Map ? ( ((Map)map).getOrDefault("serviceType", null) != null ? io.dekorate.kubernetes.annotation.ServiceType.valueOf(String.valueOf(((Map)map).getOrDefault("serviceType", null))) : null ) : null),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(i ->new PersistentVolumeClaimVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("claimName", null) : null),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new PersistentVolumeClaimVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(i ->new SecretVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("items" , new Map[0]) : new Map[0])).map(j ->new Item(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("key", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new SecretVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(i ->new ConfigMapVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("configMapName", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("items" , new Map[0]) : new Map[0])).map(j ->new Item(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("key", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new ConfigMapVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("emptyDirVolumes" , new Map[0]) : new Map[0])).map(i ->new EmptyDirVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null))).toArray(size-> new EmptyDirVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("gitRepoVolumes" , new Map[0]) : new Map[0])).map(i ->new GitRepoVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("directory", "") : ""),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("revision", "") : ""))).toArray(size-> new GitRepoVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(i ->new AwsElasticBlockStoreVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeId", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("partition", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new AwsElasticBlockStoreVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(i ->new AzureDiskVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("diskName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("diskURI", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("kind", "Managed") : "Managed"),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureDiskVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(i ->new AzureFileVolume(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("shareName", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureFileVolume[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(i ->new Mount(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("subPath", "") : ""),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   (ImagePullPolicy)(map instanceof Map ? ( ((Map)map).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)map).getOrDefault("imagePullPolicy", null))) : null ) : null),
    map instanceof Map ? toStringArray(((Map)map).get("imagePullSecrets")) : toStringArray(map),
                   (DeploymentStrategy)(map instanceof Map ? ( ((Map)map).getOrDefault("deploymentStrategy", null) != null ? io.dekorate.kubernetes.config.DeploymentStrategy.valueOf(String.valueOf(((Map)map).getOrDefault("deploymentStrategy", null))) : null ) : null),
    new RollingUpdate(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxUnavailable", "25%") : "25%"),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxSurge", "25%") : "25%")),
    null,
    new Probe(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("cpu", "") : "")),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("sidecars" , new Map[0]) : new Map[0])).map(i ->new Container(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new Env(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
    i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
    i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new Port(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", 0) : 0),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("nodePort", 0) : 0),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new Mount(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new Container[size]),
                   (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled", null) : null),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("jobs" , new Map[0]) : new Map[0])).map(i ->new Job(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("parallelism", -1) : -1),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("completions", -1) : -1),
                   io.dekorate.kubernetes.annotation.JobCompletionMode.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("completionMode","NonIndexed") : "NonIndexed")),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("backoffLimit", -1) : -1),
                   (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("activeDeadlineSeconds", -1L) : -1L),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("ttlSecondsAfterFinished", -1) : -1),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("suspend", false) : false),
                   io.dekorate.kubernetes.annotation.JobRestartPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("restartPolicy","OnFailure") : "OnFailure")),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(j ->new PersistentVolumeClaimVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("claimName", null) : null),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new PersistentVolumeClaimVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(j ->new SecretVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("items" , new Map[0]) : new Map[0])).map(k ->new Item(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("key", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new SecretVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(j ->new ConfigMapVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("configMapName", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("items" , new Map[0]) : new Map[0])).map(k ->new Item(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("key", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new ConfigMapVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("emptyDirVolumes" , new Map[0]) : new Map[0])).map(j ->new EmptyDirVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null))).toArray(size-> new EmptyDirVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(j ->new AwsElasticBlockStoreVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeId", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("partition", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AwsElasticBlockStoreVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(j ->new AzureDiskVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("diskName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("diskURI", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("kind", "Managed") : "Managed"),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureDiskVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(j ->new AzureFileVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("shareName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureFileVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("containers" , new Map[0]) : new Map[0])).map(j ->new Container(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("image", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", "") : ""),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(k ->new Env(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("value", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("secret", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("configmap", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("field", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("workingDir", "") : ""),
    j instanceof Map ? toStringArray(((Map)j).get("command")) : toStringArray(j),
    j instanceof Map ? toStringArray(((Map)j).get("arguments")) : toStringArray(j),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("ports" , new Map[0]) : new Map[0])).map(k ->new Port(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("containerPort", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("hostPort", 0) : 0),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("nodePort", 0) : 0),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(k instanceof Map ? ((Map)k).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(k ->new Mount(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("subPath", "") : ""),
                   (Boolean)(k instanceof Map ? ((Map)k).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new Container[size]))).toArray(size-> new Job[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("cronJobs" , new Map[0]) : new Map[0])).map(i ->new CronJob(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("schedule", null) : null),
                   io.dekorate.kubernetes.annotation.CronJobConcurrencyPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("concurrencyPolicy","Allow") : "Allow")),
                   (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("startingDeadlineSeconds", -1L) : -1L),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("failedJobsHistoryLimit", 1) : 1),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("successfulJobsHistoryLimit", 3) : 3),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("parallelism", -1) : -1),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("completions", -1) : -1),
                   io.dekorate.kubernetes.annotation.JobCompletionMode.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("completionMode","NonIndexed") : "NonIndexed")),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("backoffLimit", -1) : -1),
                   (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("activeDeadlineSeconds", -1L) : -1L),
                   (Integer)(i instanceof Map ? ((Map)i).getOrDefault("ttlSecondsAfterFinished", -1) : -1),
                   (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("suspend", false) : false),
                   io.dekorate.kubernetes.annotation.JobRestartPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("restartPolicy","OnFailure") : "OnFailure")),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(j ->new PersistentVolumeClaimVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("claimName", null) : null),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new PersistentVolumeClaimVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(j ->new SecretVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("items" , new Map[0]) : new Map[0])).map(k ->new Item(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("key", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new SecretVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(j ->new ConfigMapVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("configMapName", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("items" , new Map[0]) : new Map[0])).map(k ->new Item(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("key", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("mode", -1) : -1))).toArray(size-> new Item[size]))).toArray(size-> new ConfigMapVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("emptyDirVolumes" , new Map[0]) : new Map[0])).map(j ->new EmptyDirVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null))).toArray(size-> new EmptyDirVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(j ->new AwsElasticBlockStoreVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeId", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("partition", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AwsElasticBlockStoreVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(j ->new AzureDiskVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("diskName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("diskURI", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("kind", "Managed") : "Managed"),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureDiskVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(j ->new AzureFileVolume(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("shareName", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new AzureFileVolume[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("containers" , new Map[0]) : new Map[0])).map(j ->new Container(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("image", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", "") : ""),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(k ->new Env(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("value", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("secret", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("configmap", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("field", "") : ""),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("workingDir", "") : ""),
    j instanceof Map ? toStringArray(((Map)j).get("command")) : toStringArray(j),
    j instanceof Map ? toStringArray(((Map)j).get("arguments")) : toStringArray(j),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("ports" , new Map[0]) : new Map[0])).map(k ->new Port(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("containerPort", null) : null),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("hostPort", 0) : 0),
                   (Integer)(k instanceof Map ? ((Map)k).getOrDefault("nodePort", 0) : 0),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(k instanceof Map ? ((Map)k).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(k ->new Mount(
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
                   (String)(k instanceof Map ? ((Map)k).getOrDefault("subPath", "") : ""),
                   (Boolean)(k instanceof Map ? ((Map)k).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new Container[size]))).toArray(size-> new CronJob[size]),
                   Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("initContainers" , new Map[0]) : new Map[0])).map(i ->new Container(
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new Env(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", "") : ""))).toArray(size-> new Env[size]),
                   (String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
    i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
    i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new Port(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", 0) : 0),
                   (Integer)(j instanceof Map ? ((Map)j).getOrDefault("nodePort", 0) : 0),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
                   io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new Port[size]),
                   Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new Mount(
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
                   (String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
                   (Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new Mount[size]),
                   io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new Probe(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                       (Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
    new ResourceRequirements(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
    new ResourceRequirements(
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                       (String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new Container[size]),
                   (Integer)(map instanceof Map ? ((Map)map).getOrDefault("replicas", null) : null),
    new Route(
                       (Boolean)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).getOrDefault("expose", false) : false),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).getOrDefault("host", "") : ""),
                       (String)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).getOrDefault("targetPort", "http") : "http"),
    new TLSConfig(
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("caCertificate", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("certificate", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("destinationCACertificate", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("insecureEdgeTerminationPolicy", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("key", "") : ""),
                               (String)(((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null)) instanceof Map ? ((Map)((Map)(((Map)(map instanceof Map ? ((Map)map).get("route") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("route") : null))).get("tls") : null))).getOrDefault("termination", "") : ""))),
                   (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("headless", null) : null)));
  }
  
  public static String[] toStringArray(Object o) {
    if (o instanceof String[]) {
      return (String[]) o;
    }
    if (o instanceof String) {
        String s = (String) o;;
        return s.split(",[ ]*");
    }
    if (o instanceof List) {
        List l = (List) o;;
        String[] larray = new String[l.size()];;
        for (int i = 0;i == l.size();i++) {
          larray[i] = java.lang.String.valueOf(l.get(i));
        }
    }
    return new String[0];
  }
  

}