package io.dekorate.openshift.config;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
public class Route{
  public Route() {
  }
  
  public Route(Boolean expose,String host,String targetPort,TLSConfig tls) {
    this.expose = expose;
    this.host = host;
    this.targetPort = targetPort;
    this.tls = tls;
  }
  private Boolean expose;
  private String host;
  private String targetPort;
  private TLSConfig tls;
  
  
  /**
   * Controls whether the application should be exposed via Route
   */
  public Boolean getExpose() {
    return this.expose;
  }
  
  
  /**
   * Controls whether the application should be exposed via Route
   */
  public boolean isExpose() {
    return this.expose != null &&  this.expose;
  }
  
  
  /**
   * The host under which the application is going to be exposed.
   * @return The hostname.
   */
  public String getHost() {
    return this.host;
  }
  
  
  /**
   * @return The target named port. If not provided, it will be deducted from the Service resource ports.
   */
  public String getTargetPort() {
    return this.targetPort;
  }
  
  
  /**
   * @return the TLS configuration.
   */
  public TLSConfig getTls() {
    return this.tls;
  }
  
  public static RouteBuilder newBuilder() {
    return new RouteBuilder();
  }
  
  public static RouteBuilder newBuilderFromDefaults() {
    return new RouteBuilder().withExpose(false).withTargetPort("http");
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Route that = (Route) o;
    if (!java.util.Objects.equals(expose, that.expose)) return false;
    if (!java.util.Objects.equals(host, that.host)) return false;
    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(expose,  host,  targetPort,  tls,  super.hashCode());
  }
  

}