package io.dekorate.openshift.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RouteFluent<A extends RouteFluent<A>> extends BaseFluent<A>{
  public RouteFluent() {
  }
  
  public RouteFluent(Route instance) {
    this.copyInstance(instance);
  }
  private Boolean expose;
  private String host;
  private String targetPort;
  private TLSConfig tls;
  
  protected void copyInstance(Route instance) {
    instance = (instance != null ? instance : new Route());
    if (instance != null) {
          this.withExpose(instance.getExpose());
          this.withHost(instance.getHost());
          this.withTargetPort(instance.getTargetPort());
          this.withTls(instance.getTls());
        }
  }
  
  public Boolean getExpose() {
    return this.expose;
  }
  
  public A withExpose(Boolean expose) {
    this.expose = expose;
    return (A) this;
  }
  
  public boolean hasExpose() {
    return this.expose != null;
  }
  
  public String getHost() {
    return this.host;
  }
  
  public A withHost(String host) {
    this.host = host;
    return (A) this;
  }
  
  public boolean hasHost() {
    return this.host != null;
  }
  
  public String getTargetPort() {
    return this.targetPort;
  }
  
  public A withTargetPort(String targetPort) {
    this.targetPort = targetPort;
    return (A) this;
  }
  
  public boolean hasTargetPort() {
    return this.targetPort != null;
  }
  
  public TLSConfig getTls() {
    return this.tls;
  }
  
  public A withTls(TLSConfig tls) {
    this.tls = tls;
    return (A) this;
  }
  
  public boolean hasTls() {
    return this.tls != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RouteFluent that = (RouteFluent) o;
    if (!java.util.Objects.equals(expose, that.expose)) return false;
    if (!java.util.Objects.equals(host, that.host)) return false;
    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(expose,  host,  targetPort,  tls,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (expose != null) { sb.append("expose:"); sb.append(expose + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withExpose() {
    return withExpose(true);
  }
  

}