/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.openshift;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceFactories;
import io.dekorate.BuildServiceFactory;
import io.dekorate.DekorateException;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.project.Project;
import io.dekorate.testing.WithEvents;
import io.dekorate.testing.WithImageConfig;
import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.testing.WithPod;
import io.dekorate.testing.WithProject;
import io.dekorate.testing.openshift.OpenshiftReadiness;
import io.dekorate.testing.openshift.WithOpenshiftConfig;
import io.dekorate.testing.openshift.WithOpenshiftIntegrationTest;
import io.dekorate.testing.openshift.WithOpenshiftResources;
import io.dekorate.testing.openshift.WithRoute;
import io.dekorate.testing.openshift.config.OpenshiftIntegrationTestConfig;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class OpenshiftExtension
implements ExecutionCondition,
BeforeAllCallback,
AfterAllCallback,
TestWatcher,
WithOpenshiftIntegrationTest,
WithPod,
WithKubernetesClient,
WithOpenshiftResources,
WithProject,
WithEvents,
WithOpenshiftConfig,
WithImageConfig,
WithRoute {
    private final Logger LOGGER = LoggerFactory.getLogger();

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        try {
            KubernetesClient client = this.getKubernetesClient(context);
            if (!client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                String reason = "Could not detect Openshift!";
                return ConditionEvaluationResult.disabled((String)reason);
            }
            VersionInfo version = this.getKubernetesClient(context).getVersion();
            String message = "Found version:" + version.getMajor() + "." + version.getMinor();
            this.LOGGER.info(message);
            return ConditionEvaluationResult.enabled((String)message);
        }
        catch (Throwable t) {
            String reason = "Could not communicate with Openshift API server.";
            this.LOGGER.error(reason);
            return ConditionEvaluationResult.disabled((String)reason);
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        List projects = this.getProjects(context);
        for (Project project : projects) {
            this.startProject(context, project);
        }
    }

    @Override
    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        this.injectTestInstances(testInstance, context);
        if (this.hasExtensionError(context)) {
            this.displayDiagnostics(context);
        }
    }

    public void testFailed(ExtensionContext context, Throwable throwable) {
        this.displayDiagnostics(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAll(ExtensionContext context) {
        OpenshiftIntegrationTestConfig config = this.getOpenshiftIntegrationTestConfig(context);
        OpenShiftClient client = (OpenShiftClient)this.getKubernetesClient(context).adapt(OpenShiftClient.class);
        try {
            this.LOGGER.info("Cleaning up...");
            if (this.shouldDisplayDiagnostics(context)) {
                this.displayDiagnostics(context);
            }
            if (config.isDeployEnabled()) {
                List projects = this.getProjects(context);
                for (Project project : projects) {
                    this.deleteProject(context, project, client);
                }
            }
        }
        finally {
            this.closeKubernetesClient(context);
        }
    }

    @Override
    public String getName(ExtensionContext context) {
        List projects = this.getProjects(context);
        if (projects.size() != 1) {
            throw new IllegalStateException("Multiple projects found, can't use default name. Please, use `@Named` annotations for injecting instances.");
        }
        return this.getOpenshiftConfig((Project)projects.get(0)).getName();
    }

    public String[] getAdditionalModules(ExtensionContext context) {
        return this.getOpenshiftIntegrationTestConfig(context).getAdditionalModules();
    }

    private void startProject(ExtensionContext context, Project project) throws InterruptedException {
        this.LOGGER.info("Starting project at " + project.getRoot());
        OpenshiftIntegrationTestConfig config = this.getOpenshiftIntegrationTestConfig(context);
        KubernetesClient client = this.getKubernetesClient(context);
        KubernetesList list = this.getOpenshiftResources(context, project);
        if (this.hasOpenshiftConfig(project) && this.hasImageConfig(project)) {
            BuildService buildService;
            ImageConfiguration imageConfig = (ImageConfiguration)this.getImageConfig(project).get();
            try {
                BuildServiceFactory buildServiceFactory = (BuildServiceFactory)BuildServiceFactories.find((Project)project, (ImageConfiguration)imageConfig).orElseThrow(() -> new IllegalStateException("No applicable BuildServiceFactory found."));
                buildService = buildServiceFactory.create(project, imageConfig, (Collection)list.getItems());
            }
            catch (Exception e) {
                throw DekorateException.launderThrowable((String)"Failed to lookup BuildService.", (Throwable)e);
            }
            if (config.isPushEnabled()) {
                buildService.prepare();
                buildService.build();
                buildService.push();
            } else if (config.isBuildEnabled()) {
                buildService.prepare();
                buildService.build();
            }
        }
        if (config.isDeployEnabled()) {
            list.getItems().stream().filter(i -> !(i instanceof BuildConfig)).forEach(i -> {
                try {
                    HasMetadata r = (HasMetadata)((Gettable)client.resource(i).fromServer()).get();
                    if (r == null) {
                        client.resource(i).apply();
                    } else if (!(r instanceof ImageStream) && this.deleteAndWait(context, (HasMetadata)i, 1L, TimeUnit.MINUTES)) {
                        client.resource(i).apply();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                this.LOGGER.info("Created: " + i.getKind() + " name:" + i.getMetadata().getName() + ".");
            });
            List waitables = list.getItems().stream().filter(i -> i instanceof Deployment || i instanceof DeploymentConfig || i instanceof Pod || i instanceof ReplicaSet || i instanceof ReplicationController).collect(Collectors.toList());
            long started = System.currentTimeMillis();
            this.LOGGER.info("Waiting until ready (" + config.getReadinessTimeout() + " ms)...");
            this.waitUntilCondition(context, waitables, i -> OpenshiftReadiness.isReady(i), config.getReadinessTimeout(), TimeUnit.MILLISECONDS);
            long ended = System.currentTimeMillis();
            this.LOGGER.info("Waited: " + (ended - started) + " ms.");
            waitables.stream().map(r -> (HasMetadata)((Gettable)client.resource(r).fromServer()).get()).forEach(i -> {
                if (!OpenshiftReadiness.isReady(i)) {
                    this.readinessFailed(context);
                    this.LOGGER.warning(i.getKind() + ":" + i.getMetadata().getName() + " not ready!");
                }
            });
            if (this.hasReadinessFailed(context)) {
                throw new IllegalStateException("Readiness Failed");
            }
        }
    }

    private void deleteProject(ExtensionContext context, Project project, OpenShiftClient client) {
        this.getOpenshiftResources(context, project).getItems().stream().filter(r -> !(r instanceof ImageStream)).forEach(r -> {
            try {
                this.LOGGER.info("Deleting: " + r.getKind() + " name:" + r.getMetadata().getName() + ". Deleted:" + client.resource(r).delete());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        OpenshiftConfig openshiftConfig = this.getOpenshiftConfig(project);
        List buildPods = ((PodList)client.pods().list()).getItems().stream().filter(i -> i.getMetadata().getName().matches(openshiftConfig.getName() + "-\\d-build")).collect(Collectors.toList());
        try {
            client.resourceList(buildPods).delete();
            ((DeployableScalableResource)client.deploymentConfigs().withName(openshiftConfig.getName())).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void injectTestInstances(Object testInstance, ExtensionContext context) {
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            Arrays.stream(c.getDeclaredFields()).forEach(f -> {
                this.injectKubernetesClient(context, testInstance, (Field)f);
                this.injectOpenshiftResources(context, testInstance, (Field)f);
                this.injectPod(context, testInstance, (Field)f);
                this.injectRoute(context, testInstance, (Field)f);
            });
        }
    }
}

