package io.dekorate.testing.openshift.adapter;

import io.dekorate.testing.openshift.config.OpenshiftIntegrationTestConfig;
import io.dekorate.testing.openshift.config.OpenshiftIntegrationTestConfigBuilder;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import io.dekorate.testing.openshift.annotation.OpenshiftIntegrationTest;

public class OpenshiftIntegrationTestConfigAdapter {


    public static OpenshiftIntegrationTestConfig adapt(OpenshiftIntegrationTest instance) {
        return newBuilder(instance).build();
    }

    public static OpenshiftIntegrationTestConfigBuilder newBuilder(OpenshiftIntegrationTest instance) {
        return new OpenshiftIntegrationTestConfigBuilder(new io.dekorate.testing.openshift.config.OpenshiftIntegrationTestConfig(instance.deployEnabled(),
                    instance.buildEnabled(),
                    instance.pushEnabled(),
                    instance.imageStreamTagTimeout(),
                    instance.readinessTimeout()));
    }

    public static OpenshiftIntegrationTestConfig adapt(Map map) {
        return new io.dekorate.testing.openshift.config.OpenshiftIntegrationTestConfig(
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("deployEnabled","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("buildEnabled","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("pushEnabled","false") : "false")),
                       Long.parseLong(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("imageStreamTagTimeout","0") : "0")),
                       Long.parseLong(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("readinessTimeout","0") : "0")));
    }

    public static String[] toStringArray(Object o) {
                if (o instanceof String[]) {
                  return (String[]) o;
                }
                if (o instanceof String) {
                  String s =  (String) o;
                  return s.split(",[ ]*");
                }
                else if (o instanceof List) {
                  List c = (List) o;
                  String[] result = new String[c.size()]; 
                  for (int i=0; i <= c.size(); i++) {
                    result[i] = String.valueOf(c.get(i));
                  }
                  return result;
                }
                return new String[0];
            
    }

}
