package io.dekorate.testing.openshift.config;

import java.lang.Object;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class OpenshiftIntegrationTestConfig {

    private boolean deployEnabled;
    private boolean buildEnabled;
    private boolean pushEnabled;
    private long imageStreamTagTimeout;
    private long readinessTimeout;

    public OpenshiftIntegrationTestConfig() {
    }

    public OpenshiftIntegrationTestConfig(boolean deployEnabled,boolean buildEnabled,boolean pushEnabled,long imageStreamTagTimeout,long readinessTimeout) {
        this.deployEnabled = deployEnabled;
        this.buildEnabled = buildEnabled;
        this.pushEnabled = pushEnabled;
        this.imageStreamTagTimeout = imageStreamTagTimeout;
        this.readinessTimeout = readinessTimeout;
    }

    public boolean isDeployEnabled() {
        return this.deployEnabled;
    }

    public boolean isBuildEnabled() {
        return this.buildEnabled;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public long getImageStreamTagTimeout() {
        return this.imageStreamTagTimeout;
    }

    public long getReadinessTimeout() {
        return this.readinessTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OpenshiftIntegrationTestConfig that = (OpenshiftIntegrationTestConfig) o;
        if (deployEnabled != that.deployEnabled) return false;
        if (buildEnabled != that.buildEnabled) return false;
        if (pushEnabled != that.pushEnabled) return false;
        if (imageStreamTagTimeout != that.imageStreamTagTimeout) return false;
        if (readinessTimeout != that.readinessTimeout) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployEnabled,  buildEnabled,  pushEnabled,  imageStreamTagTimeout,  readinessTimeout,  super.hashCode());
    }

}
