package io.dekorate.testing.openshift.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenshiftIntegrationTestConfigBuilder extends OpenshiftIntegrationTestConfigFluentImpl<OpenshiftIntegrationTestConfigBuilder> implements VisitableBuilder<OpenshiftIntegrationTestConfig,OpenshiftIntegrationTestConfigBuilder> {

    OpenshiftIntegrationTestConfigFluent<?> fluent;
    Boolean validationEnabled;

    public OpenshiftIntegrationTestConfigBuilder() {
        this(true);
    }

    public OpenshiftIntegrationTestConfigBuilder(Boolean validationEnabled) {
        this(new OpenshiftIntegrationTestConfig(), validationEnabled);
    }

    public OpenshiftIntegrationTestConfigBuilder(OpenshiftIntegrationTestConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public OpenshiftIntegrationTestConfigBuilder(OpenshiftIntegrationTestConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OpenshiftIntegrationTestConfig(), validationEnabled);
    }

    public OpenshiftIntegrationTestConfigBuilder(OpenshiftIntegrationTestConfigFluent<?> fluent,OpenshiftIntegrationTestConfig instance) {
        this(fluent, instance, true);
    }

    public OpenshiftIntegrationTestConfigBuilder(OpenshiftIntegrationTestConfigFluent<?> fluent,OpenshiftIntegrationTestConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployEnabled(instance.isDeployEnabled()); 
        fluent.withBuildEnabled(instance.isBuildEnabled()); 
        fluent.withPushEnabled(instance.isPushEnabled()); 
        fluent.withImageStreamTagTimeout(instance.getImageStreamTagTimeout()); 
        fluent.withReadinessTimeout(instance.getReadinessTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenshiftIntegrationTestConfigBuilder(OpenshiftIntegrationTestConfig instance) {
        this(instance,true);
    }

    public OpenshiftIntegrationTestConfigBuilder(OpenshiftIntegrationTestConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployEnabled(instance.isDeployEnabled()); 
        this.withBuildEnabled(instance.isBuildEnabled()); 
        this.withPushEnabled(instance.isPushEnabled()); 
        this.withImageStreamTagTimeout(instance.getImageStreamTagTimeout()); 
        this.withReadinessTimeout(instance.getReadinessTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public EditableOpenshiftIntegrationTestConfig build() {
        EditableOpenshiftIntegrationTestConfig buildable = new EditableOpenshiftIntegrationTestConfig(fluent.isDeployEnabled(),fluent.isBuildEnabled(),fluent.isPushEnabled(),fluent.getImageStreamTagTimeout(),fluent.getReadinessTimeout());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenshiftIntegrationTestConfigBuilder that = (OpenshiftIntegrationTestConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
