package io.dekorate.testing.openshift.config;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Boolean;

public interface OpenshiftIntegrationTestConfigFluent<A extends OpenshiftIntegrationTestConfigFluent<A>> extends Fluent<A> {


    public boolean isDeployEnabled();
    public A withDeployEnabled(boolean deployEnabled);
    public Boolean hasDeployEnabled();
    public boolean isBuildEnabled();
    public A withBuildEnabled(boolean buildEnabled);
    public Boolean hasBuildEnabled();
    public boolean isPushEnabled();
    public A withPushEnabled(boolean pushEnabled);
    public Boolean hasPushEnabled();
    public long getImageStreamTagTimeout();
    public A withImageStreamTagTimeout(long imageStreamTagTimeout);
    public Boolean hasImageStreamTagTimeout();
    public long getReadinessTimeout();
    public A withReadinessTimeout(long readinessTimeout);
    public Boolean hasReadinessTimeout();
}
