package io.dekorate.testing.openshift.config;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class OpenshiftIntegrationTestConfigFluentImpl<A extends OpenshiftIntegrationTestConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OpenshiftIntegrationTestConfigFluent<A> {

    private boolean deployEnabled;
    private boolean buildEnabled;
    private boolean pushEnabled;
    private long imageStreamTagTimeout;
    private long readinessTimeout;

    public OpenshiftIntegrationTestConfigFluentImpl() {
    }

    public OpenshiftIntegrationTestConfigFluentImpl(OpenshiftIntegrationTestConfig instance) {
        this.withDeployEnabled(instance.isDeployEnabled()); 
        this.withBuildEnabled(instance.isBuildEnabled()); 
        this.withPushEnabled(instance.isPushEnabled()); 
        this.withImageStreamTagTimeout(instance.getImageStreamTagTimeout()); 
        this.withReadinessTimeout(instance.getReadinessTimeout()); 
    }

    public boolean isDeployEnabled() {
        return this.deployEnabled;
    }

    public A withDeployEnabled(boolean deployEnabled) {
        this.deployEnabled=deployEnabled; return (A) this;
    }

    public Boolean hasDeployEnabled() {
        return true;
    }

    public boolean isBuildEnabled() {
        return this.buildEnabled;
    }

    public A withBuildEnabled(boolean buildEnabled) {
        this.buildEnabled=buildEnabled; return (A) this;
    }

    public Boolean hasBuildEnabled() {
        return true;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public A withPushEnabled(boolean pushEnabled) {
        this.pushEnabled=pushEnabled; return (A) this;
    }

    public Boolean hasPushEnabled() {
        return true;
    }

    public long getImageStreamTagTimeout() {
        return this.imageStreamTagTimeout;
    }

    public A withImageStreamTagTimeout(long imageStreamTagTimeout) {
        this.imageStreamTagTimeout=imageStreamTagTimeout; return (A) this;
    }

    public Boolean hasImageStreamTagTimeout() {
        return true;
    }

    public long getReadinessTimeout() {
        return this.readinessTimeout;
    }

    public A withReadinessTimeout(long readinessTimeout) {
        this.readinessTimeout=readinessTimeout; return (A) this;
    }

    public Boolean hasReadinessTimeout() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OpenshiftIntegrationTestConfigFluentImpl that = (OpenshiftIntegrationTestConfigFluentImpl) o;
        if (deployEnabled != that.deployEnabled) return false;
        if (buildEnabled != that.buildEnabled) return false;
        if (pushEnabled != that.pushEnabled) return false;
        if (imageStreamTagTimeout != that.imageStreamTagTimeout) return false;
        if (readinessTimeout != that.readinessTimeout) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployEnabled,  buildEnabled,  pushEnabled,  imageStreamTagTimeout,  readinessTimeout,  super.hashCode());
    }

}
