/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.openshift;

import io.dekorate.testing.AbstractDiagonsticsService;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.client.OpenShiftClient;

public class ImageStreamDiagnostics
extends AbstractDiagonsticsService<ImageStream> {
    public ImageStreamDiagnostics(KubernetesClient client) {
        super(client);
    }

    public void display(ImageStream imageStream) {
        this.LOGGER.info("Diagnostics for kind: [ImageStream] with name : [" + imageStream.getMetadata().getName() + "].");
        this.displayStatus(imageStream);
        this.displayEvents((HasMetadata)imageStream);
    }

    public void displayStatus(ImageStream imageStream) {
        String name = imageStream.getMetadata().getName();
        ImageStream updated = (ImageStream)((Resource)((OpenShiftClient)this.getKubernetesClient().adapt(OpenShiftClient.class)).imageStreams().withName(name)).get();
        this.LOGGER.info("Spec:");
        this.LOGGER.info("\tDocker image repository:" + imageStream.getSpec().getDockerImageRepository());
        this.LOGGER.info("\tLookup policy:" + imageStream.getSpec().getLookupPolicy());
        if (updated != null) {
            this.LOGGER.info("Status:");
            this.LOGGER.info("\tDocker image repository:" + updated.getStatus().getDockerImageRepository());
            this.LOGGER.info("\tPublic docker image repository:" + updated.getStatus().getPublicDockerImageRepository());
            this.LOGGER.info("\tTags:");
            if (updated.getStatus().getTags() != null && !updated.getStatus().getTags().isEmpty()) {
                updated.getStatus().getTags().stream().peek(t -> this.LOGGER.info("\t" + t));
            } else {
                this.LOGGER.warning("\t\tNo tags found for ImageStream: [" + name + "]");
            }
        } else {
            this.LOGGER.error("Failed to retrieve ImageStream: [" + name + "]");
        }
    }
}

