/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.openshift;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;

public class OpenshiftReadiness {
    public static boolean isReady(HasMetadata item) {
        if (OpenshiftReadiness.isReadiableKubernetesResource(item)) {
            return OpenshiftReadiness.isKubernetesResourceReady(item);
        }
        if (OpenshiftReadiness.isReadiableOpenshiftResource(item)) {
            return OpenshiftReadiness.isOpenshiftResourceReady(item);
        }
        throw new IllegalArgumentException("Item needs to be one of [Node, Deployment, ReplicaSet, StatefulSet, Pod, ReplicationController], but was: [" + (item != null ? item.getKind() : "Unknown (null)") + "]");
    }

    private static boolean isKubernetesResourceReady(HasMetadata item) {
        if (item instanceof io.fabric8.kubernetes.api.model.apps.Deployment) {
            return Readiness.isDeploymentReady((io.fabric8.kubernetes.api.model.apps.Deployment)((io.fabric8.kubernetes.api.model.apps.Deployment)item));
        }
        if (item instanceof Deployment) {
            return Readiness.isExtensionsDeploymentReady((Deployment)((Deployment)item));
        }
        if (item instanceof ReplicaSet) {
            return Readiness.isReplicaSetReady((ReplicaSet)((ReplicaSet)item));
        }
        if (item instanceof Pod) {
            return Readiness.isPodReady((Pod)((Pod)item));
        }
        if (item instanceof ReplicationController) {
            return Readiness.isReplicationControllerReady((ReplicationController)((ReplicationController)item));
        }
        if (item instanceof Endpoints) {
            return Readiness.isEndpointsReady((Endpoints)((Endpoints)item));
        }
        if (item instanceof Node) {
            return Readiness.isNodeReady((Node)((Node)item));
        }
        if (item instanceof StatefulSet) {
            return Readiness.isStatefulSetReady((StatefulSet)((StatefulSet)item));
        }
        return false;
    }

    private static boolean isOpenshiftResourceReady(HasMetadata item) {
        if (item instanceof DeploymentConfig) {
            return OpenshiftReadiness.isDeploymentConfigReady((DeploymentConfig)item);
        }
        return false;
    }

    protected static boolean isReadiableKubernetesResource(HasMetadata item) {
        return item instanceof io.fabric8.kubernetes.api.model.apps.Deployment || item instanceof Deployment || item instanceof ReplicaSet || item instanceof Pod || item instanceof ReplicationController || item instanceof Endpoints || item instanceof Node || item instanceof StatefulSet;
    }

    protected static boolean isReadiableOpenshiftResource(HasMetadata item) {
        return item instanceof DeploymentConfig;
    }

    public static boolean isDeploymentConfigReady(DeploymentConfig d) {
        Utils.checkNotNull((Object)d, (String)"Deployment can't be null.");
        DeploymentConfigSpec spec = d.getSpec();
        DeploymentConfigStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }
}

