/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.openshift;

import io.dekorate.DekorateException;
import io.dekorate.testing.Testing;
import io.dekorate.testing.WithProject;
import io.dekorate.utils.Serialization;
import io.fabric8.kubernetes.api.model.KubernetesList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public interface WithOpenshiftResources
extends TestInstancePostProcessor,
WithProject {
    public static final String MANIFEST_PATH = "openshift.yml";

    default public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Arrays.stream(testInstance.getClass().getDeclaredFields()).forEach(f -> this.injectOpenshiftResources(context, testInstance, (Field)f));
    }

    default public void injectOpenshiftResources(ExtensionContext context, Object testInstance, Field field) {
        if (!field.getType().isAssignableFrom(KubernetesList.class)) {
            return;
        }
        if (!Arrays.stream(field.getDeclaredAnnotations()).filter(a -> a.annotationType().getSimpleName().equalsIgnoreCase("Inject")).findAny().isPresent()) {
            return;
        }
        field.setAccessible(true);
        try {
            field.set(testInstance, this.getOpenshiftResources(context));
        }
        catch (IllegalAccessException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }

    default public KubernetesList getOpenshiftResources(ExtensionContext context) {
        Object list = context.getStore(Testing.DEKORATE_STORE).get((Object)Testing.KUBERNETES_LIST);
        if (list instanceof KubernetesList) {
            return (KubernetesList)list;
        }
        list = this.fromManifest();
        context.getStore(Testing.DEKORATE_STORE).put((Object)Testing.KUBERNETES_LIST, list);
        return (KubernetesList)list;
    }

    default public KubernetesList fromManifest() {
        KubernetesList result = new KubernetesList();
        URL manifestUrl = WithOpenshiftResources.class.getClassLoader().getResource(this.getProject().getDekorateOutputDir() + File.separatorChar + MANIFEST_PATH);
        if (manifestUrl == null) {
            return result;
        }
        System.out.println("Apply test resources from:" + manifestUrl);
        try (InputStream is = manifestUrl.openStream();){
            result = Serialization.unmarshalAsList((InputStream)is);
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
        return result;
    }
}

