/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.openshift;

import io.dekorate.DekorateException;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.project.Project;
import io.dekorate.utils.Serialization;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public interface WithOpenshiftConfig {
    public static final String CONFIG_DIR = "config";
    public static final String OPENSHIFT_YML = "openshift.yml";

    default public OpenshiftConfig getOpenshiftConfig(Project project) {
        return this.getOpenshiftConfig(this.getOpenshiftConfigPath(project));
    }

    default public Path getOpenshiftConfigPath(Project project) {
        return project.getBuildInfo().getClassOutputDir().resolve(project.getDekorateMetaDir()).resolve(CONFIG_DIR).resolve(OPENSHIFT_YML);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public OpenshiftConfig getOpenshiftConfig(Path path) {
        File f = path.toFile();
        if (!f.exists()) throw new IllegalStateException("Expected to find openshift config at: " + path + "!");
        try (FileInputStream is = new FileInputStream(f);){
            OpenshiftConfig openshiftConfig = (OpenshiftConfig)Serialization.unmarshal((InputStream)is, OpenshiftConfig.class);
            return openshiftConfig;
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }
}

