/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.openshift;

import io.dekorate.DekorateException;
import io.dekorate.testing.WithBaseConfig;
import io.dekorate.testing.WithClosables;
import io.dekorate.testing.WithDiagnostics;
import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.testing.annotation.Named;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.client.OpenShiftClient;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public interface WithRoute
extends TestInstancePostProcessor,
WithBaseConfig,
WithKubernetesClient,
WithClosables,
WithDiagnostics {
    default public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Arrays.stream(testInstance.getClass().getDeclaredFields()).forEach(f -> this.injectRoute(context, testInstance, (Field)f));
    }

    default public void injectRoute(ExtensionContext context, Object testInstance, Field field) {
        if (!field.getType().isAssignableFrom(Route.class) && !field.getType().isAssignableFrom(URL.class)) {
            return;
        }
        if (!Arrays.stream(field.getDeclaredAnnotations()).filter(a -> a.annotationType().getSimpleName().equalsIgnoreCase("Inject")).findAny().isPresent()) {
            return;
        }
        String name = this.namedAnnotationForRoute(field).orElseGet(() -> this.getName(context));
        Route route = this.routeForName(context, name);
        field.setAccessible(true);
        try {
            if (field.getType().isAssignableFrom(Route.class)) {
                field.set(testInstance, route);
            } else if (field.getType().isAssignableFrom(URL.class)) {
                String protocol = route.getSpec().getTls() == null ? "http" : "https";
                int port = "http".equals(protocol) ? 80 : 443;
                URL url = new URL(protocol, route.getSpec().getHost(), port, route.getSpec().getPath());
                field.set(testInstance, url);
            }
        }
        catch (Exception e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }

    default public Route routeForName(ExtensionContext context, String name) {
        OpenShiftClient client = (OpenShiftClient)this.getKubernetesClient(context).adapt(OpenShiftClient.class);
        return (Route)((Resource)client.routes().withName(name)).get();
    }

    default public Optional<String> namedAnnotationForRoute(Field field) {
        return Arrays.stream(field.getDeclaredAnnotations()).filter(a -> a.annotationType().isAssignableFrom(Named.class)).map(a -> field.getAnnotation(Named.class).value()).findFirst();
    }

    public String getName(ExtensionContext var1);
}

