/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.apt;

import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.doc.Description;
import io.dekorate.option.annotation.GeneratorOptions;
import io.dekorate.option.config.GeneratorConfigBuilder;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.dekorate.utils.Strings;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Description(value="Processing generator options, which are used for customizing the generation process")
@SupportedAnnotationTypes(value={"io.dekorate.annotation.Dekorate", "io.dekorate.kubernetes.annotation.KubernetesApplication", "io.dekorate.openshift.annotation.OpenshiftApplication", "io.dekorate.knative.annotation.KnativeApplication", "io.dekorate.option.annotation.GeneratorOptions"})
public class GeneratorOptionsProcessor
extends AbstractAnnotationProcessor
implements WithSession {
    private static final String INPUT_DIR = "dekorate.input.dir";
    private static final String OUTPUT_DIR = "dekorate.output.dir";
    private static final String FALLBACK_INPUT_DIR = "META-INF/fabric8";
    private static final String FALLBACK_OUTPUT_DIR = "META-INF/fabric8";

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Session session = this.getSession();
        if (roundEnv.processingOver()) {
            session.close();
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                GeneratorOptions options = element.getAnnotation(GeneratorOptions.class);
                if (options == null) continue;
                this.configurePaths(options.inputPath(), options.outputPath());
                return false;
            }
            this.configurePaths("META-INF/fabric8", "META-INF/fabric8");
        }
        return false;
    }

    private void configurePaths(String defaultInputPath, String defaultOutputPath) {
        Session session = this.getSession();
        String inputPath = System.getProperty(INPUT_DIR, defaultInputPath);
        String outputPath = Optional.ofNullable(System.getProperty(OUTPUT_DIR)).map(path -> {
            this.resolve((String)path).mkdirs();
            return path;
        }).orElse(defaultOutputPath);
        if (this.isPathValid(inputPath)) {
            this.applyToProject(p -> p.withDekorateInputDir(inputPath));
            session.configurators().add(new ConfigurationSupplier((VisitableBuilder)new GeneratorConfigBuilder()));
        }
        if (this.isPathValid(outputPath)) {
            this.applyToProject(p -> p.withDekorateOutputDir(outputPath));
        }
    }

    private boolean isPathValid(String path) {
        return Strings.isNotNullOrEmpty((String)path) && this.resolve(path).exists();
    }

    private File resolve(String unixPath) {
        return new File(this.getProject().getBuildInfo().getClassOutputDir().toFile(), unixPath.replace('/', File.separatorChar));
    }
}

