/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.apt;

import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.doc.Description;
import io.dekorate.option.annotation.JvmOptions;
import io.dekorate.option.generator.JvmOptionsGenerator;
import io.dekorate.processor.AbstractAnnotationProcessor;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Description(value="Jvm options, which are used for the target deployment.")
@SupportedAnnotationTypes(value={"io.dekorate.option.annotation.JvmOptions"})
public class JvmOptionsProcessor
extends AbstractAnnotationProcessor
implements JvmOptionsGenerator,
WithSession {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Session session = this.getSession();
        if (roundEnv.processingOver()) {
            session.close();
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                JvmOptions options = element.getAnnotation(JvmOptions.class);
                if (options == null) continue;
                this.add(element);
            }
        }
        return false;
    }
}

