/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.option.adapter.JvmConfigAdapter;
import io.dekorate.option.annotation.JvmOptions;
import io.dekorate.option.config.JvmConfig;
import io.dekorate.option.configurator.ApplyJvmOptsConfigurator;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.Element;

public interface JvmOptionsGenerator
extends Generator {
    public static final String JVM = "jvm";

    default public String getKey() {
        return JVM;
    }

    default public Class<? extends Annotation> getAnnotation() {
        return JvmOptions.class;
    }

    default public void add(Element element) {
        JvmOptions jvmOptions = element.getAnnotation(JvmOptions.class);
        if (jvmOptions != null) {
            AnnotationConfiguration config = new AnnotationConfiguration((VisitableBuilder)JvmConfigAdapter.newBuilder(jvmOptions));
            this.on((ConfigurationSupplier<JvmConfig>)config);
        }
    }

    default public void add(Map map) {
        this.on((ConfigurationSupplier<JvmConfig>)new PropertyConfiguration((VisitableBuilder)JvmConfigAdapter.newBuilder(this.propertiesMap(map, JvmOptions.class))));
    }

    default public void on(ConfigurationSupplier<JvmConfig> config) {
        Session session = this.getSession();
        session.configurators().add(config);
        session.configurators().add((Configurator)new ApplyJvmOptsConfigurator(config));
    }
}

