/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.apt;

import io.dekorate.WithSession;
import io.dekorate.doc.Description;
import io.dekorate.option.annotation.JvmOptions;
import io.dekorate.processor.AbstractAnnotationProcessor;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@Description(value="Jvm options, which are used for the target deployment.")
@SupportedAnnotationTypes(value={"io.dekorate.option.annotation.JvmOptions"})
public class JvmOptionsProcessor
extends AbstractAnnotationProcessor
implements WithSession {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.getSession().close();
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                JvmOptions options = element.getAnnotation(JvmOptions.class);
                if (options == null) continue;
                this.process("jvm", element, JvmOptions.class);
            }
        }
        return false;
    }
}

