package io.dekorate.prometheus.adapter;

import java.nio.file.Path;
import io.dekorate.project.Project;
import io.dekorate.prometheus.config.ServiceMonitorConfig;
import io.dekorate.prometheus.config.ServiceMonitorConfigBuilder;
import io.dekorate.project.BuildInfo;
import io.dekorate.prometheus.annotation.EnableServiceMonitor;
import java.lang.String;
import io.dekorate.project.ScmInfo;
import java.util.Map;
import java.util.Comparator;

public class ServiceMonitorConfigAdapter{



    public static ServiceMonitorConfig adapt(EnableServiceMonitor instance){
            return newBuilder(instance).build();
    }

    public static ServiceMonitorConfigBuilder newBuilder(EnableServiceMonitor instance){
            return new ServiceMonitorConfigBuilder(new io.dekorate.prometheus.config.ServiceMonitorConfig(null,
            null,
            instance.port(),
            instance.path(),
            instance.interval(),
            instance.honorLabels()));
    }

    public static ServiceMonitorConfig adapt(Map map){
            return new io.dekorate.prometheus.config.ServiceMonitorConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("port", "http") : "http"),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("path", "/metrics") : "/metrics"),
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("interval","10") : "10")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("honorLabels","false") : "false")));
    }

    public static ServiceMonitorConfigBuilder newBuilder(Map map){
            return new ServiceMonitorConfigBuilder(new io.dekorate.prometheus.config.ServiceMonitorConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("port", "http") : "http"),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("path", "/metrics") : "/metrics"),
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("interval","10") : "10")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("honorLabels","false") : "false"))));
    }




}
