/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.decorator;

import io.dekorate.deps.kubernetes.api.builder.TypedVisitor;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.prometheus.model.EndpointBuilder;
import io.dekorate.prometheus.model.ServiceMonitorBuilder;

public class EndpointPathDecorator
extends NamedResourceDecorator<ServiceMonitorBuilder> {
    private final String port;
    private final String path;

    public EndpointPathDecorator(String port, String path) {
        this(ANY, port, path);
    }

    public EndpointPathDecorator(String name, String port, String path) {
        super(name);
        this.port = port;
        this.path = path;
    }

    public void andThenVisit(ServiceMonitorBuilder serviceMonitor, ObjectMeta resourceMeta) {
        serviceMonitor.accept((Visitor)new TypedVisitor<EndpointBuilder>(){

            public void visit(EndpointBuilder endpoint) {
                if (EndpointPathDecorator.this.port.equals(endpoint.getPort())) {
                    endpoint.withPath(EndpointPathDecorator.this.path);
                }
            }
        });
    }
}

