package io.dekorate.prometheus.config;

import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class ServiceMonitorConfig extends Configuration{
  public ServiceMonitorConfig() {
  }
  
  public ServiceMonitorConfig(Project project,Map<ConfigKey,Object> attributes,String port,String path,Integer interval,Boolean honorLabels) {
    super(project, attributes);
    this.port = port;
    this.path = path;
    this.interval = interval;
    this.honorLabels = honorLabels;
  }
  private String port;
  private String path;
  private Integer interval;
  private Boolean honorLabels;
  
  public String getPort() {
    return this.port;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public Integer getInterval() {
    return this.interval;
  }
  
  public Boolean getHonorLabels() {
    return this.honorLabels;
  }
  
  public boolean isHonorLabels() {
    return this.honorLabels != null &&  this.honorLabels;
  }
  
  public static ServiceMonitorConfigBuilder newServiceMonitorConfigBuilder() {
    return new ServiceMonitorConfigBuilder();
  }
  
  public static ServiceMonitorConfigBuilder newServiceMonitorConfigBuilderFromDefaults() {
    return new ServiceMonitorConfigBuilder().withPort("http").withPath("/metrics").withInterval(10).withHonorLabels(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceMonitorConfig that = (ServiceMonitorConfig) o;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(interval, that.interval)) return false;
    if (!java.util.Objects.equals(honorLabels, that.honorLabels)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(port,  path,  interval,  honorLabels,  super.hashCode());
  }
  

}