package io.dekorate.prometheus.model;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EndpointFluent<A extends EndpointFluent<A>> extends BaseFluent<A>{
  public EndpointFluent() {
  }
  
  public EndpointFluent(Endpoint instance) {
    this.copyInstance(instance);
  }
  private String port;
  private String proxyUrl;
  private String scheme;
  private IntOrString targetPort;
  private String path;
  private String interval;
  private boolean honorLabels;
  
  protected void copyInstance(Endpoint instance) {
    instance = (instance != null ? instance : new Endpoint());
    if (instance != null) {
          this.withPort(instance.getPort());
          this.withProxyUrl(instance.getProxyUrl());
          this.withScheme(instance.getScheme());
          this.withTargetPort(instance.getTargetPort());
          this.withPath(instance.getPath());
          this.withInterval(instance.getInterval());
          this.withHonorLabels(instance.isHonorLabels());
        }
  }
  
  public String getPort() {
    return this.port;
  }
  
  public A withPort(String port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl = proxyUrl;
    return (A) this;
  }
  
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  public String getScheme() {
    return this.scheme;
  }
  
  public A withScheme(String scheme) {
    this.scheme = scheme;
    return (A) this;
  }
  
  public boolean hasScheme() {
    return this.scheme != null;
  }
  
  public IntOrString getTargetPort() {
    return this.targetPort;
  }
  
  public A withTargetPort(IntOrString targetPort) {
    this.targetPort = targetPort;
    return (A) this;
  }
  
  public boolean hasTargetPort() {
    return this.targetPort != null;
  }
  
  public A withNewTargetPort(Object value) {
    return (A)withTargetPort(new IntOrString(value));
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public String getInterval() {
    return this.interval;
  }
  
  public A withInterval(String interval) {
    this.interval = interval;
    return (A) this;
  }
  
  public boolean hasInterval() {
    return this.interval != null;
  }
  
  public boolean isHonorLabels() {
    return this.honorLabels;
  }
  
  public A withHonorLabels(boolean honorLabels) {
    this.honorLabels = honorLabels;
    return (A) this;
  }
  
  public boolean hasHonorLabels() {
    return true;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointFluent that = (EndpointFluent) o;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;
    if (!java.util.Objects.equals(scheme, that.scheme)) return false;
    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(interval, that.interval)) return false;
    if (honorLabels != that.honorLabels) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(port,  proxyUrl,  scheme,  targetPort,  path,  interval,  honorLabels,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    sb.append("honorLabels:"); sb.append(honorLabels);
    sb.append("}");
    return sb.toString();
  }
  
  public A withHonorLabels() {
    return withHonorLabels(true);
  }
  

}