/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.project.Project;
import io.dekorate.prometheus.config.ServiceMonitorConfigBuilder;
import java.util.Map;
import java.util.Objects;

public class ServiceMonitorConfig
extends Configuration {
    private String port;
    private String path;
    private Integer interval;
    private Boolean honorLabels;

    public ServiceMonitorConfig() {
    }

    public ServiceMonitorConfig(Project project, Map<ConfigKey, Object> attributes, String port, String path, Integer interval, Boolean honorLabels) {
        super(project, attributes);
        this.port = port;
        this.path = path;
        this.interval = interval;
        this.honorLabels = honorLabels;
    }

    public String getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public Boolean getHonorLabels() {
        return this.honorLabels;
    }

    public boolean isHonorLabels() {
        return this.honorLabels != null && this.honorLabels != false;
    }

    public static ServiceMonitorConfigBuilder newServiceMonitorConfigBuilder() {
        return new ServiceMonitorConfigBuilder();
    }

    public static ServiceMonitorConfigBuilder newServiceMonitorConfigBuilderFromDefaults() {
        return (ServiceMonitorConfigBuilder)((Object)((ServiceMonitorConfigBuilder)((Object)((ServiceMonitorConfigBuilder)((Object)((ServiceMonitorConfigBuilder)((Object)new ServiceMonitorConfigBuilder().withPort("http"))).withPath("/metrics"))).withInterval(10))).withHonorLabels(false));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceMonitorConfig that = (ServiceMonitorConfig)((Object)o);
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.interval, that.interval)) {
            return false;
        }
        return Objects.equals(this.honorLabels, that.honorLabels);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.path, this.interval, this.honorLabels, super.hashCode());
    }
}

