/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.decorator;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.EnvVar;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.openshift.api.model.BuildConfigBuilder;
import io.dekorate.deps.openshift.api.model.BuildConfigFluent;
import io.dekorate.deps.openshift.api.model.BuildConfigSpecFluent;
import io.dekorate.deps.openshift.api.model.BuildOutputFluent;
import io.dekorate.deps.openshift.api.model.BuildStrategyFluent;
import io.dekorate.deps.openshift.api.model.SourceBuildStrategyFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.utils.Images;

@Description(value="Add a BuildConfig resource to the list of generated resources.")
public class AddBuildConfigResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final String IMAGESTREAMTAG = "ImageStreamTag";
    private static final String LATEST = "latest";
    private S2iBuildConfig config;

    public AddBuildConfigResourceDecorator(S2iBuildConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        String repository = Images.getRepository((String)this.config.getBuilderImage());
        String builderRepository = Images.getRepository((String)this.config.getBuilderImage());
        String builderTag = Images.getTag((String)this.config.getBuilderImage());
        String builderName = !builderRepository.contains("/") ? builderRepository : builderRepository.substring(builderRepository.lastIndexOf("/") + 1);
        String version = meta.getLabels().getOrDefault("version", LATEST);
        list.addToItems((VisitableBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyFluent.SourceStrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(this.config.getName())).withLabels(meta.getLabels())).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind(IMAGESTREAMTAG)).withName(this.config.getName() + ":" + version)).endTo()).endOutput()).withNewSource().withNewBinary().endBinary()).endSource()).withNewStrategy().withNewSourceStrategy().withEnv(new EnvVar[0])).withNewFrom().withKind(IMAGESTREAMTAG)).withName(builderName + ":" + builderTag)).endFrom()).endSourceStrategy()).endStrategy()).endSpec());
    }
}

