package io.dekorate.s2i.adapter;

import java.nio.file.Path;
import io.dekorate.s2i.config.S2iBuildConfig;
import java.util.stream.Collectors;
import io.dekorate.s2i.config.S2iBuildConfigBuilder;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import java.util.Comparator;
import io.dekorate.project.Project;
import io.dekorate.project.BuildInfo;
import io.dekorate.s2i.annotation.S2iBuild;
import io.dekorate.project.ScmInfo;
import java.util.Arrays;
import java.util.Map;

public class S2iBuildConfigAdapter{



    public static S2iBuildConfig adapt(S2iBuild instance){
            return newBuilder(instance).build();
    }

    public static S2iBuildConfigBuilder newBuilder(S2iBuild instance){
            return new S2iBuildConfigBuilder(new io.dekorate.s2i.config.S2iBuildConfig(null,
            null,
            instance.registry(),
            instance.group(),
            instance.name(),
            instance.version(),
            instance.image(),
            instance.dockerFile(),
            instance.autoBuildEnabled(),
            instance.autoPushEnabled(),
            instance.enabled(),
            instance.builderImage(),
            Arrays.asList(instance.buildEnvVars()).stream().map(i ->new io.dekorate.kubernetes.config.Env(i.name(),
            i.value(),
            i.secret(),
            i.configmap(),
            i.field())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            instance.autoDeployEnabled()));
    }

    public static S2iBuildConfig adapt(Map map){
            return new io.dekorate.s2i.config.S2iBuildConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("registry", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("group", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("image", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("dockerFile", "Dockerfile") : "Dockerfile"),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoBuildEnabled","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoPushEnabled","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("enabled","true") : "true")),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("builderImage", "fabric8/s2i-java:2.3") : "fabric8/s2i-java:2.3"),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("buildEnvVars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Env(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("secret", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("field", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled","false") : "false")));
    }

    public static S2iBuildConfigBuilder newBuilder(Map map){
            return new S2iBuildConfigBuilder(new io.dekorate.s2i.config.S2iBuildConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("registry", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("group", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("image", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("dockerFile", "Dockerfile") : "Dockerfile"),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoBuildEnabled","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoPushEnabled","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("enabled","true") : "true")),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("builderImage", "fabric8/s2i-java:2.3") : "fabric8/s2i-java:2.3"),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("buildEnvVars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Env(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("secret", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("field", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled","false") : "false"))));
    }




}
