package io.dekorate.s2i.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfiguration;
import java.lang.Object;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class S2iBuildConfig extends ImageConfiguration{

    private boolean enabled = true;
    private String builderImage = "fabric8/s2i-java:2.3";
    private io.dekorate.kubernetes.config.Env[] buildEnvVars = new io.dekorate.kubernetes.config.Env[0];
    private boolean autoDeployEnabled = false;

    public S2iBuildConfig(){
    }
    public S2iBuildConfig(Project project,Map<ConfigKey,Object> attributes,String registry,String group,String name,String version,String image,String dockerFile,boolean autoBuildEnabled,boolean autoPushEnabled,boolean enabled,String builderImage,io.dekorate.kubernetes.config.Env[] buildEnvVars,boolean autoDeployEnabled){
            super(project, attributes, registry, group, name, version, image, dockerFile, autoBuildEnabled, autoPushEnabled);
            this.enabled = enabled;
            this.builderImage = builderImage != null ? builderImage : "fabric8/s2i-java:2.3";
            this.buildEnvVars = buildEnvVars != null ? buildEnvVars : new io.dekorate.kubernetes.config.Env[0];
            this.autoDeployEnabled = autoDeployEnabled;
    }

    public boolean isEnabled(){
            return this.enabled;
    }

    public String getBuilderImage(){
            return this.builderImage;
    }

    public io.dekorate.kubernetes.config.Env[] getBuildEnvVars(){
            return this.buildEnvVars;
    }

    public boolean isAutoDeployEnabled(){
            return this.autoDeployEnabled;
    }

    public static S2iBuildConfigBuilder newS2iBuildConfigBuilder(){
            return new io.dekorate.s2i.config.S2iBuildConfigBuilder();
    }




}
