/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.handler;

import io.dekorate.Configurators;
import io.dekorate.Handler;
import io.dekorate.HandlerFactory;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Resources;
import io.dekorate.WithProject;
import io.dekorate.deps.kubernetes.api.model.EnvVar;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.openshift.api.model.BuildConfig;
import io.dekorate.deps.openshift.api.model.BuildConfigBuilder;
import io.dekorate.deps.openshift.api.model.BuildConfigFluent;
import io.dekorate.deps.openshift.api.model.BuildConfigSpecFluent;
import io.dekorate.deps.openshift.api.model.BuildOutputFluent;
import io.dekorate.deps.openshift.api.model.BuildStrategyFluent;
import io.dekorate.deps.openshift.api.model.ImageStream;
import io.dekorate.deps.openshift.api.model.ImageStreamBuilder;
import io.dekorate.deps.openshift.api.model.ImageStreamFluent;
import io.dekorate.deps.openshift.api.model.SourceBuildStrategyFluent;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.s2i.config.EditableS2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.decorator.AddBuildEnvDecorator;
import io.dekorate.utils.Images;

public class S2iHanlder
implements Handler<S2iBuildConfig>,
HandlerFactory,
WithProject {
    private static final String OPENSHIFT = "openshift";
    private static final String IMAGESTREAMTAG = "ImageStreamTag";
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final Resources resources;

    public S2iHanlder(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 1301;
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(S2iBuildConfig.class) || type.equals(EditableS2iBuildConfig.class);
    }

    public Handler create(Resources resources, Configurators configurators) {
        return new S2iHanlder(resources);
    }

    public void handle(S2iBuildConfig config) {
        if (config.isEnabled()) {
            this.LOGGER.info("Processing s2i configuration.");
            this.resources.add(OPENSHIFT, (HasMetadata)this.createBuilderImageStream(config));
            this.resources.add(OPENSHIFT, (HasMetadata)this.createProjectImageStream());
            this.resources.add(OPENSHIFT, (HasMetadata)this.createBuildConfig(config));
            for (Env env : config.getBuildEnvVars()) {
                this.resources.decorate((Decorator)new AddBuildEnvDecorator(env));
            }
        }
    }

    public ImageStream createBuilderImageStream(S2iBuildConfig config) {
        String repository = Images.getRepository((String)config.getBuilderImage());
        String name = !repository.contains("/") ? repository : repository.substring(repository.lastIndexOf("/") + 1);
        String dockerImageRepo = config.getBuilderImage().contains(":") ? config.getBuilderImage().substring(0, config.getBuilderImage().indexOf(":")) : config.getBuilderImage();
        return ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(name)).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec().withDockerImageRepository(dockerImageRepo)).endSpec()).build();
    }

    public ImageStream createProjectImageStream() {
        return ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(this.resources.getName())).withLabels(this.resources.getLabels())).endMetadata()).build();
    }

    public BuildConfig createBuildConfig(S2iBuildConfig config) {
        String builderRepository = Images.getRepository((String)config.getBuilderImage());
        String builderTag = Images.getTag((String)config.getBuilderImage());
        String builderName = !builderRepository.contains("/") ? builderRepository : builderRepository.substring(builderRepository.lastIndexOf("/") + 1);
        return ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyFluent.SourceStrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(this.resources.getName())).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind(IMAGESTREAMTAG)).withName(this.resources.getName() + ":" + this.resources.getVersion())).endTo()).endOutput()).withNewSource().withNewBinary().endBinary()).endSource()).withNewStrategy().withNewSourceStrategy().withEnv(new EnvVar[0])).withNewFrom().withKind(IMAGESTREAMTAG)).withName(builderName + ":" + builderTag)).endFrom()).endSourceStrategy()).endStrategy()).endSpec()).build();
    }
}

