/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.handler;

import io.dekorate.Configurators;
import io.dekorate.Handler;
import io.dekorate.HandlerFactory;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Resources;
import io.dekorate.WithProject;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.s2i.config.EditableS2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.decorator.AddBuildConfigResourceDecorator;
import io.dekorate.s2i.decorator.AddBuildEnvDecorator;
import io.dekorate.s2i.decorator.AddBuilderImageStreamResourceDecorator;
import io.dekorate.s2i.decorator.AddOutputImageStreamResourceDecorator;

public class S2iHanlder
implements Handler<S2iBuildConfig>,
HandlerFactory,
WithProject {
    private static final String OPENSHIFT = "openshift";
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final Resources resources;

    public S2iHanlder(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 1301;
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(S2iBuildConfig.class) || type.equals(EditableS2iBuildConfig.class);
    }

    public Handler create(Resources resources, Configurators configurators) {
        return new S2iHanlder(resources);
    }

    public void handle(S2iBuildConfig config) {
        if (config.isEnabled()) {
            this.LOGGER.info("Processing s2i configuration.");
            this.resources.decorate(OPENSHIFT, (Decorator)new AddBuilderImageStreamResourceDecorator(config));
            this.resources.decorate(OPENSHIFT, (Decorator)new AddOutputImageStreamResourceDecorator(config));
            this.resources.decorate(OPENSHIFT, (Decorator)new AddBuildConfigResourceDecorator(config));
            for (Env env : config.getBuildEnvVars()) {
                this.resources.decorate((Decorator)new AddBuildEnvDecorator(env));
            }
        }
    }
}

