/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.decorator;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.openshift.api.model.ImageStreamBuilder;
import io.dekorate.deps.openshift.api.model.ImageStreamFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.utils.Images;

@Description(value="Add a builder ImageStream resource to the list of generated resources.")
public class AddBuilderImageStreamResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private S2iBuildConfig config;

    public AddBuilderImageStreamResourceDecorator(S2iBuildConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        String repository = Images.getRepository((String)this.config.getBuilderImage());
        String name = !repository.contains("/") ? repository : repository.substring(repository.lastIndexOf("/") + 1);
        String dockerImageRepo = Images.removeTag((String)this.config.getBuilderImage());
        list.addToItems((VisitableBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(name)).withLabels(meta.getLabels())).endMetadata()).withNewSpec().withDockerImageRepository(dockerImageRepo)).endSpec());
    }
}

