/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.config;

import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.EnvFluent;
import io.dekorate.kubernetes.config.EnvFluentImpl;
import io.dekorate.kubernetes.config.ImageConfigurationFluentImpl;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class S2iBuildConfigFluentImpl<A extends S2iBuildConfigFluent<A>>
extends ImageConfigurationFluentImpl<A>
implements S2iBuildConfigFluent<A> {
    private boolean enabled = true;
    private String builderImage = "fabric8/s2i-java:2.3";
    private List<EnvBuilder> buildEnvVars = new ArrayList<EnvBuilder>();
    private boolean autoDeployEnabled = false;

    public S2iBuildConfigFluentImpl() {
    }

    public S2iBuildConfigFluentImpl(S2iBuildConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withRegistry(instance.getRegistry());
        this.withGroup(instance.getGroup());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withImage(instance.getImage());
        this.withDockerFile(instance.getDockerFile());
        this.withAutoBuildEnabled(instance.isAutoBuildEnabled());
        this.withAutoPushEnabled(instance.isAutoPushEnabled());
        this.withEnabled(instance.isEnabled());
        this.withBuilderImage(instance.getBuilderImage());
        this.withBuildEnvVars(instance.getBuildEnvVars());
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public A withEnabled(boolean enabled) {
        this.enabled = enabled;
        return (A)this;
    }

    @Override
    public Boolean hasEnabled() {
        return true;
    }

    @Override
    public String getBuilderImage() {
        return this.builderImage;
    }

    @Override
    public A withBuilderImage(String builderImage) {
        this.builderImage = builderImage;
        return (A)this;
    }

    @Override
    public Boolean hasBuilderImage() {
        return this.builderImage != null;
    }

    @Override
    public A withNewBuilderImage(String arg1) {
        return this.withBuilderImage(new String(arg1));
    }

    @Override
    public A withNewBuilderImage(StringBuilder arg1) {
        return this.withBuilderImage(new String(arg1));
    }

    @Override
    public A withNewBuilderImage(StringBuffer arg1) {
        return this.withBuilderImage(new String(arg1));
    }

    @Override
    public A withBuildEnvVars(Env ... buildEnvVars) {
        if (this.buildEnvVars != null) {
            this.buildEnvVars.clear();
        }
        if (buildEnvVars != null) {
            for (Env item : buildEnvVars) {
                this.addToBuildEnvVars(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Env[] getBuildEnvVars() {
        int size = this.buildEnvVars != null ? this.buildEnvVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.buildEnvVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildBuildEnvVars() {
        int size = this.buildEnvVars != null ? this.buildEnvVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.buildEnvVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildBuildEnvVar(int index) {
        return this.buildEnvVars.get(index).build();
    }

    @Override
    public Env buildFirstBuildEnvVar() {
        return this.buildEnvVars.get(0).build();
    }

    @Override
    public Env buildLastBuildEnvVar() {
        return this.buildEnvVars.get(this.buildEnvVars.size() - 1).build();
    }

    @Override
    public Env buildMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.buildEnvVars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.buildEnvVars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToBuildEnvVars(int index, Env item) {
        if (this.buildEnvVars == null) {
            this.buildEnvVars = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.get((Object)"buildEnvVars").add(index >= 0 ? index : this._visitables.get((Object)"buildEnvVars").size(), builder);
        this.buildEnvVars.add(index >= 0 ? index : this.buildEnvVars.size(), builder);
        return (A)this;
    }

    @Override
    public A setToBuildEnvVars(int index, Env item) {
        if (this.buildEnvVars == null) {
            this.buildEnvVars = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"buildEnvVars").size()) {
            this._visitables.get((Object)"buildEnvVars").add(builder);
        } else {
            this._visitables.get((Object)"buildEnvVars").set(index, builder);
        }
        if (index < 0 || index >= this.buildEnvVars.size()) {
            this.buildEnvVars.add(builder);
        } else {
            this.buildEnvVars.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBuildEnvVars(Env ... items) {
        if (this.buildEnvVars == null) {
            this.buildEnvVars = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"buildEnvVars").add(builder);
            this.buildEnvVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigBuildEnvVars(Collection<Env> items) {
        if (this.buildEnvVars == null) {
            this.buildEnvVars = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"buildEnvVars").add(builder);
            this.buildEnvVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBuildEnvVars(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"buildEnvVars").remove(builder);
            if (this.buildEnvVars == null) continue;
            this.buildEnvVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigBuildEnvVars(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"buildEnvVars").remove(builder);
            if (this.buildEnvVars == null) continue;
            this.buildEnvVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConfigBuildEnvVars(Predicate<EnvBuilder> predicate) {
        if (this.buildEnvVars == null) {
            return (A)this;
        }
        Iterator<EnvBuilder> each = this.buildEnvVars.iterator();
        List visitables = this._visitables.get((Object)"buildEnvVars");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasBuildEnvVars() {
        return this.buildEnvVars != null && !this.buildEnvVars.isEmpty();
    }

    @Override
    public A addNewConfigBuildEnvVar(String name, String value, String secret, String configmap, String field) {
        return this.addToBuildEnvVars(new Env(name, value, secret, configmap, field));
    }

    @Override
    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> addNewConfigBuildEnvVar() {
        return new ConfigBuildEnvVarsNestedImpl();
    }

    @Override
    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> addNewBuildEnvVarLike(Env item) {
        return new ConfigBuildEnvVarsNestedImpl(-1, item);
    }

    @Override
    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> setNewBuildEnvVarLike(int index, Env item) {
        return new ConfigBuildEnvVarsNestedImpl(index, item);
    }

    @Override
    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> editBuildEnvVar(int index) {
        if (this.buildEnvVars.size() <= index) {
            throw new RuntimeException("Can't edit buildEnvVars. Index exceeds size.");
        }
        return this.setNewBuildEnvVarLike(index, this.buildBuildEnvVar(index));
    }

    @Override
    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> editFirstBuildEnvVar() {
        if (this.buildEnvVars.size() == 0) {
            throw new RuntimeException("Can't edit first buildEnvVars. The list is empty.");
        }
        return this.setNewBuildEnvVarLike(0, this.buildBuildEnvVar(0));
    }

    @Override
    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> editLastBuildEnvVar() {
        int index = this.buildEnvVars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last buildEnvVars. The list is empty.");
        }
        return this.setNewBuildEnvVarLike(index, this.buildBuildEnvVar(index));
    }

    @Override
    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> editMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.buildEnvVars.size(); ++i) {
            if (!predicate.apply((Object)this.buildEnvVars.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching buildEnvVars. No match found.");
        }
        return this.setNewBuildEnvVarLike(index, this.buildBuildEnvVar(index));
    }

    @Override
    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    @Override
    public A withAutoDeployEnabled(boolean autoDeployEnabled) {
        this.autoDeployEnabled = autoDeployEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasAutoDeployEnabled() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        S2iBuildConfigFluentImpl that = (S2iBuildConfigFluentImpl)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.builderImage != null ? !this.builderImage.equals(that.builderImage) : that.builderImage != null) {
            return false;
        }
        if (this.buildEnvVars != null ? !this.buildEnvVars.equals(that.buildEnvVars) : that.buildEnvVars != null) {
            return false;
        }
        return this.autoDeployEnabled == that.autoDeployEnabled;
    }

    public class ConfigBuildEnvVarsNestedImpl<N>
    extends EnvFluentImpl<S2iBuildConfigFluent.ConfigBuildEnvVarsNested<N>>
    implements S2iBuildConfigFluent.ConfigBuildEnvVarsNested<N>,
    Nested<N> {
        private final EnvBuilder builder;
        private final int index;

        ConfigBuildEnvVarsNestedImpl(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder((EnvFluent)this, item);
        }

        ConfigBuildEnvVarsNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder((EnvFluent)this);
        }

        @Override
        public N and() {
            return (N)S2iBuildConfigFluentImpl.this.setToBuildEnvVars(this.index, (Env)this.builder.build());
        }

        @Override
        public N endConfigBuildEnvVar() {
            return this.and();
        }
    }
}

