/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.handler;

import io.dekorate.BuildServiceFactories;
import io.dekorate.Configurators;
import io.dekorate.Handler;
import io.dekorate.HandlerFactory;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Resources;
import io.dekorate.WithProject;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.project.Project;
import io.dekorate.s2i.config.EditableS2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.decorator.AddBuildConfigResourceDecorator;
import io.dekorate.s2i.decorator.AddBuildEnvDecorator;
import io.dekorate.s2i.decorator.AddBuilderImageStreamResourceDecorator;
import io.dekorate.s2i.decorator.AddDockerImageStreamResourceDecorator;
import io.dekorate.s2i.decorator.AddOutputImageStreamResourceDecorator;
import io.dekorate.utils.Images;
import io.dekorate.utils.Strings;

public class S2iHanlder
implements Handler<S2iBuildConfig>,
HandlerFactory,
WithProject {
    private static final String OPENSHIFT = "openshift";
    private static final String JAVA_APP_JAR = "JAVA_APP_JAR";
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final Resources resources;
    private final Configurators configurators;

    public S2iHanlder(Resources resources, Configurators configurators) {
        this.resources = resources;
        this.configurators = configurators;
    }

    public int order() {
        return 1301;
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(S2iBuildConfig.class) || type.equals(EditableS2iBuildConfig.class);
    }

    public Handler create(Resources resources, Configurators configurators) {
        return new S2iHanlder(resources, configurators);
    }

    public void handle(S2iBuildConfig config) {
        if (config.isEnabled()) {
            this.LOGGER.info("Processing s2i configuration.");
            this.resources.decorate(OPENSHIFT, (Decorator)new AddBuilderImageStreamResourceDecorator(config));
            this.resources.decorate(OPENSHIFT, (Decorator)new AddOutputImageStreamResourceDecorator(config));
            this.resources.decorate(OPENSHIFT, (Decorator)new AddBuildConfigResourceDecorator(config));
            for (Env env : config.getBuildEnvVars()) {
                this.resources.decorate((Decorator)new AddBuildEnvDecorator(env));
            }
            this.resources.decorate(OPENSHIFT, (Decorator)new AddEnvVarDecorator(config.getName(), config.getName(), (Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(JAVA_APP_JAR)).withValue("/deployments/" + config.getProject().getBuildInfo().getOutputFile().getFileName().toString())).build()));
        } else {
            ImageConfiguration imageConfig = this.configurators.getImageConfig(BuildServiceFactories.supplierMatches((Project)this.getProject()).and(i -> Strings.isNotNullOrEmpty((String)((ImageConfiguration)i.get()).getRegistry()))).orElse(null);
            if (imageConfig != null) {
                String image = Images.getImage((String)imageConfig.getRegistry(), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
                String repository = imageConfig.getRegistry() + "/" + Images.getRepository((String)image);
                this.resources.decorate(OPENSHIFT, (Decorator)new AddDockerImageStreamResourceDecorator(imageConfig, repository));
            }
        }
    }
}

