/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.util;

import io.dekorate.kubernetes.decorator.Decorator;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class S2iUtils {
    private static final OpenShiftClient client = new DefaultOpenShiftClient();

    public static boolean waitForImageStreamTags(Collection<HasMetadata> items, long amount, TimeUnit timeUnit) {
        if (items == null || items.isEmpty()) {
            return true;
        }
        final ArrayList tags = new ArrayList();
        ((KubernetesListBuilder)((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).accept(new Visitor[]{new Decorator<SourceBuildStrategyFluent>(){

            public void visit(SourceBuildStrategyFluent strategy) {
                ObjectReference from = strategy.buildFrom();
                if (from.getKind().equals("ImageStreamTag")) {
                    tags.add(from.getName());
                }
            }
        }})).build();
        boolean tagsMissing = true;
        long started = System.currentTimeMillis();
        long elapsed = 0L;
        while (tagsMissing && elapsed < timeUnit.toMillis(amount) && !Thread.interrupted()) {
            tagsMissing = false;
            for (String tag : tags) {
                ImageStreamTag t = (ImageStreamTag)((Resource)client.imageStreamTags().withName(tag)).get();
                if (t != null) continue;
                tagsMissing = true;
            }
            if (!tagsMissing) continue;
            try {
                Thread.sleep(1000L);
                elapsed = System.currentTimeMillis() - started;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return !tagsMissing;
    }
}

