package io.dekorate.s2i.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfiguration;
import java.lang.Object;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class S2iBuildConfig extends ImageConfiguration {

    private Boolean enabled;
    private String builderImage;
    private io.dekorate.kubernetes.config.Env[] buildEnvVars = new io.dekorate.kubernetes.config.Env[0];
    private Boolean autoDeployEnabled;

    public S2iBuildConfig() {
    }

    public S2iBuildConfig(Project project,Map<ConfigKey,Object> attributes,String registry,String group,String name,String version,String image,String dockerFile,Boolean autoBuildEnabled,Boolean autoPushEnabled,Boolean enabled,String builderImage,io.dekorate.kubernetes.config.Env[] buildEnvVars,Boolean autoDeployEnabled) {
        super(project, attributes, registry, group, name, version, image, dockerFile, autoBuildEnabled, autoPushEnabled);
        this.enabled = enabled;
        this.builderImage = builderImage;
        this.buildEnvVars = buildEnvVars != null ? buildEnvVars : new io.dekorate.kubernetes.config.Env[0];
        this.autoDeployEnabled = autoDeployEnabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled != null &&  this.enabled;
    }

    public String getBuilderImage() {
        return this.builderImage;
    }

    public io.dekorate.kubernetes.config.Env[] getBuildEnvVars() {
        return this.buildEnvVars;
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled != null &&  this.autoDeployEnabled;
    }

    public static S2iBuildConfigBuilder newS2iBuildConfigBuilder() {
        return new io.dekorate.s2i.config.S2iBuildConfigBuilder();
    }

    public static S2iBuildConfigBuilder newS2iBuildConfigBuilderFromDefaults() {
        return new io.dekorate.s2i.config.S2iBuildConfigBuilder().withEnabled(true).withDockerFile("Dockerfile").withBuilderImage("fabric8/s2i-java:2.3").withAutoPushEnabled(false).withAutoBuildEnabled(false).withAutoDeployEnabled(false);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        S2iBuildConfig that = (S2iBuildConfig) o;
        if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
        if (builderImage != null ? !builderImage.equals(that.builderImage) :that.builderImage != null) return false;
        if (buildEnvVars != null ? !buildEnvVars.equals(that.buildEnvVars) :that.buildEnvVars != null) return false;
        if (autoDeployEnabled != null ? !autoDeployEnabled.equals(that.autoDeployEnabled) :that.autoDeployEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(enabled,  builderImage,  buildEnvVars,  autoDeployEnabled,  super.hashCode());
    }

}
