package io.dekorate.s2i.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.ImageConfigurationFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.EnvFluentImpl;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class S2iBuildConfigFluentImpl<A extends S2iBuildConfigFluent<A>> extends ImageConfigurationFluentImpl<A> implements S2iBuildConfigFluent<A> {

    private Boolean enabled;
    private String builderImage;
    private List<EnvBuilder> buildEnvVars =  new ArrayList<EnvBuilder>();
    private Boolean autoDeployEnabled;

    public S2iBuildConfigFluentImpl() {
    }

    public S2iBuildConfigFluentImpl(S2iBuildConfig instance) {
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withRegistry(instance.getRegistry()); 
        this.withGroup(instance.getGroup()); 
        this.withName(instance.getName()); 
        this.withVersion(instance.getVersion()); 
        this.withImage(instance.getImage()); 
        this.withDockerFile(instance.getDockerFile()); 
        this.withAutoBuildEnabled(instance.getAutoBuildEnabled()); 
        this.withAutoPushEnabled(instance.getAutoPushEnabled()); 
        this.withEnabled(instance.getEnabled()); 
        this.withBuilderImage(instance.getBuilderImage()); 
        this.withBuildEnvVars(instance.getBuildEnvVars()); 
        this.withAutoDeployEnabled(instance.getAutoDeployEnabled()); 
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled=enabled; return (A) this;
    }

    public Boolean hasEnabled() {
        return this.enabled != null;
    }

    public A withNewEnabled(String arg1) {
        return (A)withEnabled(new Boolean(arg1));
    }

    public A withNewEnabled(boolean arg1) {
        return (A)withEnabled(new Boolean(arg1));
    }

    public String getBuilderImage() {
        return this.builderImage;
    }

    public A withBuilderImage(String builderImage) {
        this.builderImage=builderImage; return (A) this;
    }

    public Boolean hasBuilderImage() {
        return this.builderImage != null;
    }

    public A withNewBuilderImage(String arg1) {
        return (A)withBuilderImage(new String(arg1));
    }

    public A withNewBuilderImage(StringBuilder arg1) {
        return (A)withBuilderImage(new String(arg1));
    }

    public A withNewBuilderImage(StringBuffer arg1) {
        return (A)withBuilderImage(new String(arg1));
    }

    public A withBuildEnvVars(io.dekorate.kubernetes.config.Env... buildEnvVars) {
        if (this.buildEnvVars != null) {this.buildEnvVars.clear();}
        if (buildEnvVars != null) {for (io.dekorate.kubernetes.config.Env item :buildEnvVars){ this.addToBuildEnvVars(item);}} return (A) this;
    }

    
/**
 * This method has been deprecated, please use method buildBuildEnvVars instead.
 */
@Deprecated public io.dekorate.kubernetes.config.Env[] getBuildEnvVars() {
        int size = buildEnvVars != null ? buildEnvVars.size() : 0;
        io.dekorate.kubernetes.config.Env[] result = new io.dekorate.kubernetes.config.Env[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (VisitableBuilder<? extends io.dekorate.kubernetes.config.Env,?> builder : buildEnvVars) {
            result[index++]=builder.build();
        }
        return result;
    }

    public io.dekorate.kubernetes.config.Env[] buildBuildEnvVars() {
        int size = buildEnvVars != null ? buildEnvVars.size() : 0;
        io.dekorate.kubernetes.config.Env[] result = new io.dekorate.kubernetes.config.Env[size];
        if (size == 0) {
           return result;
        }
        int index = 0;
        for (VisitableBuilder<? extends io.dekorate.kubernetes.config.Env,?> builder : buildEnvVars) {
            result[index++]=builder.build();
        }
        return result;
    }

    public io.dekorate.kubernetes.config.Env buildBuildEnvVar(int index) {
        return this.buildEnvVars.get(index).build();
    }

    public io.dekorate.kubernetes.config.Env buildFirstBuildEnvVar() {
        return this.buildEnvVars.get(0).build();
    }

    public io.dekorate.kubernetes.config.Env buildLastBuildEnvVar() {
        return this.buildEnvVars.get(buildEnvVars.size() - 1).build();
    }

    public io.dekorate.kubernetes.config.Env buildMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item: buildEnvVars) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item: buildEnvVars) { if(predicate.test(item)){ return true;} } return false;
    }

    public A addToBuildEnvVars(int index,io.dekorate.kubernetes.config.Env item) {
        if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
        io.dekorate.kubernetes.config.EnvBuilder builder = new io.dekorate.kubernetes.config.EnvBuilder(item);_visitables.get("buildEnvVars").add(index >= 0 ? index : _visitables.get("buildEnvVars").size(), builder);this.buildEnvVars.add(index >= 0 ? index : buildEnvVars.size(), builder); return (A)this;
    }

    public A setToBuildEnvVars(int index,io.dekorate.kubernetes.config.Env item) {
        if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
        io.dekorate.kubernetes.config.EnvBuilder builder = new io.dekorate.kubernetes.config.EnvBuilder(item);
        if (index < 0 || index >= _visitables.get("buildEnvVars").size()) { _visitables.get("buildEnvVars").add(builder); } else { _visitables.get("buildEnvVars").set(index, builder);}
        if (index < 0 || index >= buildEnvVars.size()) { buildEnvVars.add(builder); } else { buildEnvVars.set(index, builder);}
         return (A)this;
    }

    public A addToBuildEnvVars(io.dekorate.kubernetes.config.Env... items) {
        if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
        for (io.dekorate.kubernetes.config.Env item : items) {io.dekorate.kubernetes.config.EnvBuilder builder = new io.dekorate.kubernetes.config.EnvBuilder(item);_visitables.get("buildEnvVars").add(builder);this.buildEnvVars.add(builder);} return (A)this;
    }

    public A addAllToConfigBuildEnvVars(Collection<io.dekorate.kubernetes.config.Env> items) {
        if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
        for (io.dekorate.kubernetes.config.Env item : items) {io.dekorate.kubernetes.config.EnvBuilder builder = new io.dekorate.kubernetes.config.EnvBuilder(item);_visitables.get("buildEnvVars").add(builder);this.buildEnvVars.add(builder);} return (A)this;
    }

    public A removeFromBuildEnvVars(io.dekorate.kubernetes.config.Env... items) {
        for (io.dekorate.kubernetes.config.Env item : items) {io.dekorate.kubernetes.config.EnvBuilder builder = new io.dekorate.kubernetes.config.EnvBuilder(item);_visitables.get("buildEnvVars").remove(builder);if (this.buildEnvVars != null) {this.buildEnvVars.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfigBuildEnvVars(Collection<io.dekorate.kubernetes.config.Env> items) {
        for (io.dekorate.kubernetes.config.Env item : items) {io.dekorate.kubernetes.config.EnvBuilder builder = new io.dekorate.kubernetes.config.EnvBuilder(item);_visitables.get("buildEnvVars").remove(builder);if (this.buildEnvVars != null) {this.buildEnvVars.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfigBuildEnvVars(Predicate<EnvBuilder> predicate) {
        if (buildEnvVars == null) return (A) this;
        final Iterator<EnvBuilder> each = buildEnvVars.iterator();
        final List visitables = _visitables.get("buildEnvVars");
        while (each.hasNext()) {
          EnvBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public Boolean hasBuildEnvVars() {
        return buildEnvVars != null && !buildEnvVars.isEmpty();
    }

    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> addNewConfigBuildEnvVar() {
        return new ConfigBuildEnvVarsNestedImpl();
    }

    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> addNewBuildEnvVarLike(io.dekorate.kubernetes.config.Env item) {
        return new ConfigBuildEnvVarsNestedImpl(-1, item);
    }

    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> setNewBuildEnvVarLike(int index,io.dekorate.kubernetes.config.Env item) {
        return new ConfigBuildEnvVarsNestedImpl(index, item);
    }

    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> editBuildEnvVar(int index) {
        if (buildEnvVars.size() <= index) throw new RuntimeException("Can't edit buildEnvVars. Index exceeds size.");
        return setNewBuildEnvVarLike(index, buildBuildEnvVar(index));
    }

    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> editFirstBuildEnvVar() {
        if (buildEnvVars.size() == 0) throw new RuntimeException("Can't edit first buildEnvVars. The list is empty.");
        return setNewBuildEnvVarLike(0, buildBuildEnvVar(0));
    }

    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> editLastBuildEnvVar() {
        int index = buildEnvVars.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last buildEnvVars. The list is empty.");
        return setNewBuildEnvVarLike(index, buildBuildEnvVar(index));
    }

    public S2iBuildConfigFluent.ConfigBuildEnvVarsNested<A> editMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i=0;i<buildEnvVars.size();i++) { 
        if (predicate.test(buildEnvVars.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching buildEnvVars. No match found.");
        return setNewBuildEnvVarLike(index, buildBuildEnvVar(index));
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public A withAutoDeployEnabled(Boolean autoDeployEnabled) {
        this.autoDeployEnabled=autoDeployEnabled; return (A) this;
    }

    public Boolean hasAutoDeployEnabled() {
        return this.autoDeployEnabled != null;
    }

    public A withNewAutoDeployEnabled(String arg1) {
        return (A)withAutoDeployEnabled(new Boolean(arg1));
    }

    public A withNewAutoDeployEnabled(boolean arg1) {
        return (A)withAutoDeployEnabled(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        S2iBuildConfigFluentImpl that = (S2iBuildConfigFluentImpl) o;
        if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
        if (builderImage != null ? !builderImage.equals(that.builderImage) :that.builderImage != null) return false;
        if (buildEnvVars != null ? !buildEnvVars.equals(that.buildEnvVars) :that.buildEnvVars != null) return false;
        if (autoDeployEnabled != null ? !autoDeployEnabled.equals(that.autoDeployEnabled) :that.autoDeployEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(enabled,  builderImage,  buildEnvVars,  autoDeployEnabled,  super.hashCode());
    }

    public class ConfigBuildEnvVarsNestedImpl<N> extends EnvFluentImpl<S2iBuildConfigFluent.ConfigBuildEnvVarsNested<N>> implements S2iBuildConfigFluent.ConfigBuildEnvVarsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EnvBuilder builder;
        private final int index;

            ConfigBuildEnvVarsNestedImpl(int index,io.dekorate.kubernetes.config.Env item) {
                this.index = index;
                this.builder = new EnvBuilder(this, item);
                        
            }

            ConfigBuildEnvVarsNestedImpl() {
                this.index = -1;
                this.builder = new EnvBuilder(this);
                        
            }

            public N and() {
                return (N) S2iBuildConfigFluentImpl.this.setToBuildEnvVars(index,builder.build());
            }

            public N endConfigBuildEnvVar() {
                return and();
            }
    }


}
