/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.manifest;

import io.dekorate.BuildServiceFactories;
import io.dekorate.ConfigurationRegistry;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.ManifestGenerator;
import io.dekorate.ResourceRegistry;
import io.dekorate.WithProject;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.project.Project;
import io.dekorate.s2i.config.EditableS2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.decorator.AddBuildConfigResourceDecorator;
import io.dekorate.s2i.decorator.AddBuildEnvDecorator;
import io.dekorate.s2i.decorator.AddBuilderImageStreamResourceDecorator;
import io.dekorate.s2i.decorator.AddDockerImageStreamResourceDecorator;
import io.dekorate.s2i.decorator.AddOutputImageStreamResourceDecorator;
import io.dekorate.utils.Images;
import io.dekorate.utils.Strings;

public class S2iManifestGenerator
implements ManifestGenerator<S2iBuildConfig>,
WithProject {
    private static final String OPENSHIFT = "openshift";
    private static final String JAVA_APP_JAR = "JAVA_APP_JAR";
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final ResourceRegistry resourceRegistry;
    private final ConfigurationRegistry configurationRegistry;

    public S2iManifestGenerator(ResourceRegistry resourceRegistry, ConfigurationRegistry configurationRegistry) {
        this.resourceRegistry = resourceRegistry;
        this.configurationRegistry = configurationRegistry;
    }

    public int order() {
        return 1301;
    }

    public String getKey() {
        return OPENSHIFT;
    }

    public boolean accepts(Class<? extends Configuration> type) {
        return type.equals(S2iBuildConfig.class) || type.equals(EditableS2iBuildConfig.class);
    }

    public void generate(S2iBuildConfig config) {
        if (config.isEnabled()) {
            this.LOGGER.info("Processing s2i configuration.");
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new AddBuilderImageStreamResourceDecorator(config));
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new AddOutputImageStreamResourceDecorator(config));
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new AddBuildConfigResourceDecorator(config));
            for (Env env : config.getBuildEnvVars()) {
                this.resourceRegistry.decorate((Decorator)new AddBuildEnvDecorator(env));
            }
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new AddEnvVarDecorator(config.getName(), config.getName(), (Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(JAVA_APP_JAR)).withValue("/deployments/" + config.getProject().getBuildInfo().getOutputFile().getFileName().toString())).build()));
        } else {
            String registry;
            ImageConfiguration imageConfig = this.configurationRegistry.getImageConfig(BuildServiceFactories.supplierMatches((Project)this.getProject())).orElse(null);
            String string = registry = Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? "docker.io" : imageConfig.getRegistry();
            if (imageConfig != null) {
                String image = Images.getImage((String)registry, (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
                String repository = registry + "/" + Images.getRepository((String)image);
                this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new AddDockerImageStreamResourceDecorator(imageConfig, repository));
            }
        }
    }
}

