package io.dekorate.s2i.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfiguration;
import java.lang.Object;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @io.sundr.builder.annotations.Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class S2iBuildConfig extends io.dekorate.kubernetes.config.ImageConfiguration{
  public S2iBuildConfig() {
  }
  public S2iBuildConfig(io.dekorate.project.Project project,java.util.Map<io.dekorate.kubernetes.config.ConfigKey,java.lang.Object> attributes,java.lang.Boolean enabled,java.lang.String registry,java.lang.String group,java.lang.String name,java.lang.String version,java.lang.String image,java.lang.String dockerFile,java.lang.Boolean autoBuildEnabled,java.lang.Boolean autoPushEnabled,java.lang.Boolean autoLoadEnabled,java.lang.String builderImage,io.dekorate.kubernetes.config.Env[] buildEnvVars,java.lang.Boolean autoDeployEnabled) {
    super(project, attributes, enabled, registry, group, name, version, image, dockerFile, autoBuildEnabled, autoPushEnabled, autoLoadEnabled);
    this.builderImage = builderImage;
    this.buildEnvVars = buildEnvVars != null ? buildEnvVars : new io.dekorate.kubernetes.config.Env[0];
    this.autoDeployEnabled = autoDeployEnabled;
  }
  private java.lang.String builderImage;
  private io.dekorate.kubernetes.config.Env[] buildEnvVars = new io.dekorate.kubernetes.config.Env[0];
  private java.lang.Boolean autoDeployEnabled;
  
  /**
   * The S2i builder image to use.
   * @return The builder image.
   */
public java.lang.String getBuilderImage() {
    return this.builderImage;
  }
  
  /**
   * Environment variables to use for the s2i build.
   * @return The environment variables.
   */
public io.dekorate.kubernetes.config.Env[] getBuildEnvVars() {
    return this.buildEnvVars;
  }
  
  /**
   * Flag to trigger the registration of the deploy hook. It's generally
   * preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.
   * @return True for automatic registration of the build hook.
   */
public java.lang.Boolean getAutoDeployEnabled() {
    return this.autoDeployEnabled;
  }
  
  /**
   * Flag to trigger the registration of the deploy hook. It's generally
   * preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.
   * @return True for automatic registration of the build hook.
   */
public boolean isAutoDeployEnabled() {
    return this.autoDeployEnabled != null &&  this.autoDeployEnabled;
  }
  public static io.dekorate.s2i.config.S2iBuildConfigBuilder newS2iBuildConfigBuilder() {
    return new io.dekorate.s2i.config.S2iBuildConfigBuilder();
  }
  public static io.dekorate.s2i.config.S2iBuildConfigBuilder newS2iBuildConfigBuilderFromDefaults() {
    return new io.dekorate.s2i.config.S2iBuildConfigBuilder().withEnabled(true).withDockerFile("Dockerfile").withBuilderImage("fabric8/s2i-java:2.3").withAutoPushEnabled(false).withAutoBuildEnabled(false).withAutoDeployEnabled(false);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    S2iBuildConfig that = (S2iBuildConfig) o;
    if (builderImage != null ? !builderImage.equals(that.builderImage) :that.builderImage != null) return false;
    if (buildEnvVars != null ? !buildEnvVars.equals(that.buildEnvVars) :that.buildEnvVars != null) return false;
    if (autoDeployEnabled != null ? !autoDeployEnabled.equals(that.autoDeployEnabled) :that.autoDeployEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(builderImage,  buildEnvVars,  autoDeployEnabled,  super.hashCode());
  }
  
}