/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.utils.Images;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;

@Description(value="Add a builder ImageStream resource to the list of generated resources.")
public class AddBuilderImageStreamResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private S2iBuildConfig config;

    public AddBuilderImageStreamResourceDecorator(S2iBuildConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        String name;
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        String repository = Images.getRepository((String)this.config.getBuilderImage());
        String string = name = !repository.contains("/") ? repository : repository.substring(repository.lastIndexOf("/") + 1);
        if (this.contains(list, "image.openshift.io/v1", "ImageStream", name)) {
            return;
        }
        String dockerImageRepo = Images.removeTag((String)this.config.getBuilderImage());
        list.addToItems((VisitableBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(name)).withLabels(meta.getLabels())).endMetadata()).withNewSpec().withDockerImageRepository(dockerImageRepo)).endSpec());
    }
}

