/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;

@Description(value="Add a output ImageStream resource to the list of generated resources.")
public class AddOutputImageStreamResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final S2iBuildConfig config;

    public AddOutputImageStreamResourceDecorator(S2iBuildConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        if (this.contains(list, "image.openshift.io/v1", "ImageStream", this.config.getName())) {
            return;
        }
        list.addToItems((VisitableBuilder)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(this.config.getName())).withLabels(meta.getLabels())).endMetadata()).withNewSpec().endSpec());
    }
}

