/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.decorator;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.RemoveLabelDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.utils.Images;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import java.util.Arrays;
import java.util.List;

@Description(value="Add a BuildConfig resource to the list of generated resources.")
public class AddBuildConfigResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder>
implements WithConfigReferences {
    private static final String IMAGESTREAMTAG = "ImageStreamTag";
    private static final String LATEST = "latest";
    private S2iBuildConfig config;

    public AddBuildConfigResourceDecorator(S2iBuildConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        String version;
        ObjectMeta meta = this.getDeploymentMetadata(list, this.config.getName()).orElseGet(ObjectMeta::new);
        String builderTag = Images.getTag((String)this.config.getBuilderImage());
        String builderName = this.getImageStreamName();
        String fallbackVersion = Strings.isNotNullOrEmpty((String)this.config.getVersion()) ? this.config.getVersion() : LATEST;
        String string = version = meta.getLabels() != null ? meta.getLabels().getOrDefault("app.kubernetes.io/version", fallbackVersion) : fallbackVersion;
        if (this.contains(list, "build.openshift.io/v1", "BuildConfig", this.config.getName())) {
            return;
        }
        list.addToItems((VisitableBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyFluent.SourceStrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(this.config.getName())).withLabels(meta.getLabels())).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind(IMAGESTREAMTAG)).withName(this.config.getName() + ":" + version)).endTo()).endOutput()).withNewSource().withNewBinary().endBinary()).endSource()).withNewStrategy().withNewSourceStrategy().withEnv(new EnvVar[0])).withNewFrom().withKind(IMAGESTREAMTAG)).withName(builderName + ":" + builderTag)).endFrom()).endSourceStrategy()).endStrategy()).endSpec());
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddLabelDecorator.class, RemoveLabelDecorator.class};
    }

    public List<ConfigReference> getConfigReferences() {
        return Arrays.asList(this.buildConfigReferenceTag());
    }

    private ConfigReference buildConfigReferenceTag() {
        String property = ConfigReference.generateConfigReferenceName((String)"tag", (String[])new String[]{this.config.getName(), this.getImageStreamName()});
        String jsonPath = "$.[?(@.kind == 'BuildConfig' && @.metadata.name == '" + this.config.getName() + "')].spec.strategy.sourceStrategy.from.name";
        return new ConfigReference(property, jsonPath);
    }

    private String getImageStreamName() {
        String repository = Images.getRepository((String)this.config.getBuilderImage());
        return !repository.contains("/") ? repository : repository.substring(repository.lastIndexOf("/") + 1);
    }
}

