package io.dekorate.s2i.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.ImageConfigurationFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import java.util.function.Predicate;
import java.lang.Integer;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.EnvFluentImpl;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class S2iBuildConfigFluentImpl<A extends S2iBuildConfigFluent<A>> extends ImageConfigurationFluentImpl<A> implements S2iBuildConfigFluent<A>{
  public S2iBuildConfigFluentImpl() {
  }
  public S2iBuildConfigFluentImpl(S2iBuildConfig instance) {
    this.withProject(instance.getProject()); 
    this.withAttributes(instance.getAttributes()); 
    this.withEnabled(instance.getEnabled()); 
    this.withRegistry(instance.getRegistry()); 
    this.withGroup(instance.getGroup()); 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withImage(instance.getImage()); 
    this.withDockerFile(instance.getDockerFile()); 
    this.withAutoBuildEnabled(instance.getAutoBuildEnabled()); 
    this.withAutoPushEnabled(instance.getAutoPushEnabled()); 
    this.withAutoLoadEnabled(instance.isAutoLoadEnabled()); 
    this.withBuilderImage(instance.getBuilderImage()); 
    this.withBuildEnvVars(instance.getBuildEnvVars()); 
    this.withAutoDeployEnabled(instance.getAutoDeployEnabled()); 
  }
  private String builderImage;
  private ArrayList<EnvBuilder> buildEnvVars = new ArrayList<EnvBuilder>();
  private Boolean autoDeployEnabled;
  public String getBuilderImage() {
    return this.builderImage;
  }
  public A withBuilderImage(String builderImage) {
    this.builderImage=builderImage; return (A) this;
  }
  public Boolean hasBuilderImage() {
    return this.builderImage != null;
  }
  public A withBuildEnvVars(io.dekorate.kubernetes.config.Env... buildEnvVars) {
    if (this.buildEnvVars != null) {this.buildEnvVars.clear();}
    if (buildEnvVars != null) {for (Env item :buildEnvVars){ this.addToBuildEnvVars(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildBuildEnvVars instead.
   */
  @Deprecated
  public Env[] getBuildEnvVars() {
    int size = buildEnvVars != null ? buildEnvVars.size() : 0;
Env[] result = new Env[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Env,?> builder : buildEnvVars) {
    result[index++]=builder.build();
}
return result;

  }
  public Env[] buildBuildEnvVars() {
    int size = buildEnvVars != null ? buildEnvVars.size() : 0;
Env[] result = new Env[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Env,?> builder : buildEnvVars) {
    result[index++]=builder.build();
}
return result;

  }
  public Env buildBuildEnvVar(Integer index) {
    return this.buildEnvVars.get(index).build();
  }
  public Env buildFirstBuildEnvVar() {
    return this.buildEnvVars.get(0).build();
  }
  public Env buildLastBuildEnvVar() {
    return this.buildEnvVars.get(buildEnvVars.size() - 1).build();
  }
  public Env buildMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
    for (EnvBuilder item: buildEnvVars) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
    for (EnvBuilder item: buildEnvVars) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToBuildEnvVars(Integer index,Env item) {
    if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);_visitables.get("buildEnvVars").add(index >= 0 ? index : _visitables.get("buildEnvVars").size(), builder);this.buildEnvVars.add(index >= 0 ? index : buildEnvVars.size(), builder); return (A)this;
  }
  public A setToBuildEnvVars(Integer index,Env item) {
    if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= _visitables.get("buildEnvVars").size()) { _visitables.get("buildEnvVars").add(builder); } else { _visitables.get("buildEnvVars").set(index, builder);}
    if (index < 0 || index >= buildEnvVars.size()) { buildEnvVars.add(builder); } else { buildEnvVars.set(index, builder);}
     return (A)this;
  }
  public A addToBuildEnvVars(io.dekorate.kubernetes.config.Env... items) {
    if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("buildEnvVars").add(builder);this.buildEnvVars.add(builder);} return (A)this;
  }
  public A addAllToBuildEnvVars(Collection<Env> items) {
    if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("buildEnvVars").add(builder);this.buildEnvVars.add(builder);} return (A)this;
  }
  public A removeFromBuildEnvVars(io.dekorate.kubernetes.config.Env... items) {
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("buildEnvVars").remove(builder);if (this.buildEnvVars != null) {this.buildEnvVars.remove(builder);}} return (A)this;
  }
  public A removeAllFromBuildEnvVars(Collection<Env> items) {
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("buildEnvVars").remove(builder);if (this.buildEnvVars != null) {this.buildEnvVars.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBuildEnvVars(Predicate<EnvBuilder> predicate) {
    if (buildEnvVars == null) return (A) this;
    final Iterator<EnvBuilder> each = buildEnvVars.iterator();
    final List visitables = _visitables.get("buildEnvVars");
    while (each.hasNext()) {
      EnvBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasBuildEnvVars() {
    return buildEnvVars != null && !buildEnvVars.isEmpty();
  }
  public S2iBuildConfigFluent.BuildEnvVarsNested<A> addNewBuildEnvVar() {
    return new S2iBuildConfigFluentImpl.BuildEnvVarsNestedImpl();
  }
  public S2iBuildConfigFluent.BuildEnvVarsNested<A> addNewBuildEnvVarLike(Env item) {
    return new S2iBuildConfigFluentImpl.BuildEnvVarsNestedImpl(-1, item);
  }
  public S2iBuildConfigFluent.BuildEnvVarsNested<A> setNewBuildEnvVarLike(Integer index,Env item) {
    return new S2iBuildConfigFluentImpl.BuildEnvVarsNestedImpl(index, item);
  }
  public S2iBuildConfigFluent.BuildEnvVarsNested<A> editBuildEnvVar(Integer index) {
    if (buildEnvVars.size() <= index) throw new RuntimeException("Can't edit buildEnvVars. Index exceeds size.");
    return setNewBuildEnvVarLike(index, buildBuildEnvVar(index));
  }
  public S2iBuildConfigFluent.BuildEnvVarsNested<A> editFirstBuildEnvVar() {
    if (buildEnvVars.size() == 0) throw new RuntimeException("Can't edit first buildEnvVars. The list is empty.");
    return setNewBuildEnvVarLike(0, buildBuildEnvVar(0));
  }
  public S2iBuildConfigFluent.BuildEnvVarsNested<A> editLastBuildEnvVar() {
    int index = buildEnvVars.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last buildEnvVars. The list is empty.");
    return setNewBuildEnvVarLike(index, buildBuildEnvVar(index));
  }
  public S2iBuildConfigFluent.BuildEnvVarsNested<A> editMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
    int index = -1;
    for (int i=0;i<buildEnvVars.size();i++) { 
    if (predicate.test(buildEnvVars.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching buildEnvVars. No match found.");
    return setNewBuildEnvVarLike(index, buildBuildEnvVar(index));
  }
  public Boolean getAutoDeployEnabled() {
    return this.autoDeployEnabled;
  }
  public A withAutoDeployEnabled(Boolean autoDeployEnabled) {
    this.autoDeployEnabled=autoDeployEnabled; return (A) this;
  }
  public Boolean hasAutoDeployEnabled() {
    return this.autoDeployEnabled != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    S2iBuildConfigFluentImpl that = (S2iBuildConfigFluentImpl) o;
    if (builderImage != null ? !builderImage.equals(that.builderImage) :that.builderImage != null) return false;
    if (buildEnvVars != null ? !buildEnvVars.equals(that.buildEnvVars) :that.buildEnvVars != null) return false;
    if (autoDeployEnabled != null ? !autoDeployEnabled.equals(that.autoDeployEnabled) :that.autoDeployEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(builderImage,  buildEnvVars,  autoDeployEnabled,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (builderImage != null) { sb.append("builderImage:"); sb.append(builderImage + ","); }
    if (buildEnvVars != null && !buildEnvVars.isEmpty()) { sb.append("buildEnvVars:"); sb.append(buildEnvVars + ","); }
    if (autoDeployEnabled != null) { sb.append("autoDeployEnabled:"); sb.append(autoDeployEnabled); }
    sb.append("}");
    return sb.toString();
  }
  public A withAutoDeployEnabled() {
    return withAutoDeployEnabled(true);
  }
  class BuildEnvVarsNestedImpl<N> extends EnvFluentImpl<S2iBuildConfigFluent.BuildEnvVarsNested<N>> implements S2iBuildConfigFluent.BuildEnvVarsNested<N>,Nested<N>{
    BuildEnvVarsNestedImpl(Integer index,Env item) {
      this.index = index;
      this.builder = new EnvBuilder(this, item);
    }
    BuildEnvVarsNestedImpl() {
      this.index = -1;
      this.builder = new EnvBuilder(this);
    }
    EnvBuilder builder;
    Integer index;
    public N and() {
      return (N) S2iBuildConfigFluentImpl.this.setToBuildEnvVars(index,builder.build());
    }
    public N endBuildEnvVar() {
      return and();
    }
    
  }
  
}