package io.dekorate.s2i.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.dekorate.kubernetes.config.EnvFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.ImageConfigurationFluent;
import java.util.function.Predicate;
import io.dekorate.kubernetes.config.EnvBuilder;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class S2iBuildConfigFluent<A extends S2iBuildConfigFluent<A>> extends ImageConfigurationFluent<A>{
  public S2iBuildConfigFluent() {
  }
  
  public S2iBuildConfigFluent(S2iBuildConfig instance) {
    this.copyInstance(instance);
  }
  private String builderImage;
  private ArrayList<EnvBuilder> buildEnvVars = new ArrayList<EnvBuilder>();
  private Boolean autoDeployEnabled;
  
  protected void copyInstance(S2iBuildConfig instance) {
    instance = (instance != null ? instance : new S2iBuildConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withEnabled(instance.getEnabled());
          this.withRegistry(instance.getRegistry());
          this.withGroup(instance.getGroup());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withImage(instance.getImage());
          this.withDockerFile(instance.getDockerFile());
          this.withAutoBuildEnabled(instance.getAutoBuildEnabled());
          this.withAutoPushEnabled(instance.getAutoPushEnabled());
          this.withAutoLoadEnabled(instance.isAutoLoadEnabled());
          this.withBuilderImage(instance.getBuilderImage());
          this.withBuildEnvVars(instance.getBuildEnvVars());
          this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
          this.withPartOf(instance.getPartOf());
        }
  }
  
  public String getBuilderImage() {
    return this.builderImage;
  }
  
  public A withBuilderImage(String builderImage) {
    this.builderImage = builderImage;
    return (A) this;
  }
  
  public boolean hasBuilderImage() {
    return this.builderImage != null;
  }
  
  public A withBuildEnvVars(io.dekorate.kubernetes.config.Env... buildEnvVars) {
    if (this.buildEnvVars != null) {
        this.buildEnvVars.clear();
        _visitables.remove("buildEnvVars");
    }
    if (buildEnvVars != null) {
      for (Env item : buildEnvVars) {
        this.addToBuildEnvVars(item);
      }
    }
    return (A) this;
  }
  
  public Env[] buildBuildEnvVars() {
    int size = buildEnvVars != null ? buildEnvVars.size() : 0;;
    Env[] result = new Env[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Env,EnvBuilder> item : buildEnvVars) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Env buildBuildEnvVar(int index) {
    return this.buildEnvVars.get(index).build();
  }
  
  public Env buildFirstBuildEnvVar() {
    return this.buildEnvVars.get(0).build();
  }
  
  public Env buildLastBuildEnvVar() {
    return this.buildEnvVars.get(buildEnvVars.size() - 1).build();
  }
  
  public Env buildMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
      for (EnvBuilder item : buildEnvVars) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
      for (EnvBuilder item : buildEnvVars) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToBuildEnvVars(int index,Env item) {
    if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= buildEnvVars.size()) { _visitables.get("buildEnvVars").add(builder); buildEnvVars.add(builder); } else { _visitables.get("buildEnvVars").add(index, builder); buildEnvVars.add(index, builder);}
    return (A)this;
  }
  
  public A setToBuildEnvVars(int index,Env item) {
    if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= buildEnvVars.size()) { _visitables.get("buildEnvVars").add(builder); buildEnvVars.add(builder); } else { _visitables.get("buildEnvVars").set(index, builder); buildEnvVars.set(index, builder);}
    return (A)this;
  }
  
  public A addToBuildEnvVars(io.dekorate.kubernetes.config.Env... items) {
    if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("buildEnvVars").add(builder);this.buildEnvVars.add(builder);} return (A)this;
  }
  
  public A addAllToBuildEnvVars(Collection<Env> items) {
    if (this.buildEnvVars == null) {this.buildEnvVars = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("buildEnvVars").add(builder);this.buildEnvVars.add(builder);} return (A)this;
  }
  
  public A removeFromBuildEnvVars(io.dekorate.kubernetes.config.Env... items) {
    if (this.buildEnvVars == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("buildEnvVars").remove(builder); this.buildEnvVars.remove(builder);} return (A)this;
  }
  
  public A removeAllFromBuildEnvVars(Collection<Env> items) {
    if (this.buildEnvVars == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("buildEnvVars").remove(builder); this.buildEnvVars.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromBuildEnvVars(Predicate<EnvBuilder> predicate) {
    if (buildEnvVars == null) return (A) this;
    final Iterator<EnvBuilder> each = buildEnvVars.iterator();
    final List visitables = _visitables.get("buildEnvVars");
    while (each.hasNext()) {
      EnvBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasBuildEnvVars() {
    return this.buildEnvVars != null && !this.buildEnvVars.isEmpty();
  }
  
  public BuildEnvVarsNested<A> addNewBuildEnvVar() {
    return new BuildEnvVarsNested(-1, null);
  }
  
  public BuildEnvVarsNested<A> addNewBuildEnvVarLike(Env item) {
    return new BuildEnvVarsNested(-1, item);
  }
  
  public BuildEnvVarsNested<A> setNewBuildEnvVarLike(int index,Env item) {
    return new BuildEnvVarsNested(index, item);
  }
  
  public BuildEnvVarsNested<A> editBuildEnvVar(int index) {
    if (buildEnvVars.size() <= index) throw new RuntimeException("Can't edit buildEnvVars. Index exceeds size.");
    return setNewBuildEnvVarLike(index, buildBuildEnvVar(index));
  }
  
  public BuildEnvVarsNested<A> editFirstBuildEnvVar() {
    if (buildEnvVars.size() == 0) throw new RuntimeException("Can't edit first buildEnvVars. The list is empty.");
    return setNewBuildEnvVarLike(0, buildBuildEnvVar(0));
  }
  
  public BuildEnvVarsNested<A> editLastBuildEnvVar() {
    int index = buildEnvVars.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last buildEnvVars. The list is empty.");
    return setNewBuildEnvVarLike(index, buildBuildEnvVar(index));
  }
  
  public BuildEnvVarsNested<A> editMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
    int index = -1;
    for (int i=0;i<buildEnvVars.size();i++) { 
    if (predicate.test(buildEnvVars.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching buildEnvVars. No match found.");
    return setNewBuildEnvVarLike(index, buildBuildEnvVar(index));
  }
  
  public Boolean getAutoDeployEnabled() {
    return this.autoDeployEnabled;
  }
  
  public A withAutoDeployEnabled(Boolean autoDeployEnabled) {
    this.autoDeployEnabled = autoDeployEnabled;
    return (A) this;
  }
  
  public boolean hasAutoDeployEnabled() {
    return this.autoDeployEnabled != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    S2iBuildConfigFluent that = (S2iBuildConfigFluent) o;
    if (!java.util.Objects.equals(builderImage, that.builderImage)) return false;
    if (!java.util.Objects.equals(buildEnvVars, that.buildEnvVars)) return false;
    if (!java.util.Objects.equals(autoDeployEnabled, that.autoDeployEnabled)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(builderImage,  buildEnvVars,  autoDeployEnabled,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (builderImage != null) { sb.append("builderImage:"); sb.append(builderImage + ","); }
    if (buildEnvVars != null && !buildEnvVars.isEmpty()) { sb.append("buildEnvVars:"); sb.append(buildEnvVars + ","); }
    if (autoDeployEnabled != null) { sb.append("autoDeployEnabled:"); sb.append(autoDeployEnabled); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAutoDeployEnabled() {
    return withAutoDeployEnabled(true);
  }
  public class BuildEnvVarsNested<N> extends EnvFluent<BuildEnvVarsNested<N>> implements Nested<N>{
    BuildEnvVarsNested(int index,Env item) {
      this.index = index;
      this.builder = new EnvBuilder(this, item);
    }
    EnvBuilder builder;
    int index;
    
    public N and() {
      return (N) S2iBuildConfigFluent.this.setToBuildEnvVars(index,builder.build());
    }
    
    public N endBuildEnvVar() {
      return and();
    }
    
  
  }

}