/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.config;

import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.EnvFluent;
import io.dekorate.kubernetes.config.ImageConfigurationFluent;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class S2iBuildConfigFluent<A extends S2iBuildConfigFluent<A>>
extends ImageConfigurationFluent<A> {
    private String builderImage;
    private ArrayList<EnvBuilder> buildEnvVars = new ArrayList();
    private Boolean autoDeployEnabled;

    public S2iBuildConfigFluent() {
    }

    public S2iBuildConfigFluent(S2iBuildConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(S2iBuildConfig instance) {
        S2iBuildConfig s2iBuildConfig = instance = instance != null ? instance : new S2iBuildConfig();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withEnabled(instance.getEnabled());
            this.withRegistry(instance.getRegistry());
            this.withGroup(instance.getGroup());
            this.withName(instance.getName());
            this.withVersion(instance.getVersion());
            this.withImage(instance.getImage());
            this.withDockerFile(instance.getDockerFile());
            this.withAutoBuildEnabled(instance.getAutoBuildEnabled());
            this.withAutoPushEnabled(instance.getAutoPushEnabled());
            this.withAutoLoadEnabled(instance.isAutoLoadEnabled());
            this.withBuilderImage(instance.getBuilderImage());
            this.withBuildEnvVars(instance.getBuildEnvVars());
            this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
            this.withPartOf(instance.getPartOf());
        }
    }

    public String getBuilderImage() {
        return this.builderImage;
    }

    public A withBuilderImage(String builderImage) {
        this.builderImage = builderImage;
        return (A)((Object)this);
    }

    public boolean hasBuilderImage() {
        return this.builderImage != null;
    }

    public A withBuildEnvVars(Env ... buildEnvVars) {
        if (this.buildEnvVars != null) {
            this.buildEnvVars.clear();
            this._visitables.remove((Object)"buildEnvVars");
        }
        if (buildEnvVars != null) {
            for (Env item : buildEnvVars) {
                this.addToBuildEnvVars(item);
            }
        }
        return (A)((Object)this);
    }

    public Env[] buildBuildEnvVars() {
        int size = this.buildEnvVars != null ? this.buildEnvVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.buildEnvVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    public Env buildBuildEnvVar(int index) {
        return this.buildEnvVars.get(index).build();
    }

    public Env buildFirstBuildEnvVar() {
        return this.buildEnvVars.get(0).build();
    }

    public Env buildLastBuildEnvVar() {
        return this.buildEnvVars.get(this.buildEnvVars.size() - 1).build();
    }

    public Env buildMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.buildEnvVars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.buildEnvVars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToBuildEnvVars(int index, Env item) {
        if (this.buildEnvVars == null) {
            this.buildEnvVars = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.buildEnvVars.size()) {
            this._visitables.get((Object)"buildEnvVars").add(builder);
            this.buildEnvVars.add(builder);
        } else {
            this._visitables.get((Object)"buildEnvVars").add(index, builder);
            this.buildEnvVars.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToBuildEnvVars(int index, Env item) {
        if (this.buildEnvVars == null) {
            this.buildEnvVars = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.buildEnvVars.size()) {
            this._visitables.get((Object)"buildEnvVars").add(builder);
            this.buildEnvVars.add(builder);
        } else {
            this._visitables.get((Object)"buildEnvVars").set(index, builder);
            this.buildEnvVars.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToBuildEnvVars(Env ... items) {
        if (this.buildEnvVars == null) {
            this.buildEnvVars = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"buildEnvVars").add(builder);
            this.buildEnvVars.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBuildEnvVars(Collection<Env> items) {
        if (this.buildEnvVars == null) {
            this.buildEnvVars = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"buildEnvVars").add(builder);
            this.buildEnvVars.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromBuildEnvVars(Env ... items) {
        if (this.buildEnvVars == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"buildEnvVars").remove(builder);
            this.buildEnvVars.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBuildEnvVars(Collection<Env> items) {
        if (this.buildEnvVars == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"buildEnvVars").remove(builder);
            this.buildEnvVars.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBuildEnvVars(Predicate<EnvBuilder> predicate) {
        if (this.buildEnvVars == null) {
            return (A)((Object)this);
        }
        Iterator<EnvBuilder> each = this.buildEnvVars.iterator();
        List visitables = this._visitables.get((Object)"buildEnvVars");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasBuildEnvVars() {
        return this.buildEnvVars != null && !this.buildEnvVars.isEmpty();
    }

    public BuildEnvVarsNested<A> addNewBuildEnvVar() {
        return new BuildEnvVarsNested(-1, null);
    }

    public BuildEnvVarsNested<A> addNewBuildEnvVarLike(Env item) {
        return new BuildEnvVarsNested(-1, item);
    }

    public BuildEnvVarsNested<A> setNewBuildEnvVarLike(int index, Env item) {
        return new BuildEnvVarsNested(index, item);
    }

    public BuildEnvVarsNested<A> editBuildEnvVar(int index) {
        if (this.buildEnvVars.size() <= index) {
            throw new RuntimeException("Can't edit buildEnvVars. Index exceeds size.");
        }
        return this.setNewBuildEnvVarLike(index, this.buildBuildEnvVar(index));
    }

    public BuildEnvVarsNested<A> editFirstBuildEnvVar() {
        if (this.buildEnvVars.size() == 0) {
            throw new RuntimeException("Can't edit first buildEnvVars. The list is empty.");
        }
        return this.setNewBuildEnvVarLike(0, this.buildBuildEnvVar(0));
    }

    public BuildEnvVarsNested<A> editLastBuildEnvVar() {
        int index = this.buildEnvVars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last buildEnvVars. The list is empty.");
        }
        return this.setNewBuildEnvVarLike(index, this.buildBuildEnvVar(index));
    }

    public BuildEnvVarsNested<A> editMatchingBuildEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.buildEnvVars.size(); ++i) {
            if (!predicate.test(this.buildEnvVars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching buildEnvVars. No match found.");
        }
        return this.setNewBuildEnvVarLike(index, this.buildBuildEnvVar(index));
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public A withAutoDeployEnabled(Boolean autoDeployEnabled) {
        this.autoDeployEnabled = autoDeployEnabled;
        return (A)((Object)this);
    }

    public boolean hasAutoDeployEnabled() {
        return this.autoDeployEnabled != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        S2iBuildConfigFluent that = (S2iBuildConfigFluent)((Object)o);
        if (!Objects.equals(this.builderImage, that.builderImage)) {
            return false;
        }
        if (!Objects.equals(this.buildEnvVars, that.buildEnvVars)) {
            return false;
        }
        return Objects.equals(this.autoDeployEnabled, that.autoDeployEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.builderImage, this.buildEnvVars, this.autoDeployEnabled, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.builderImage != null) {
            sb.append("builderImage:");
            sb.append(this.builderImage + ",");
        }
        if (this.buildEnvVars != null && !this.buildEnvVars.isEmpty()) {
            sb.append("buildEnvVars:");
            sb.append(this.buildEnvVars + ",");
        }
        if (this.autoDeployEnabled != null) {
            sb.append("autoDeployEnabled:");
            sb.append(this.autoDeployEnabled);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAutoDeployEnabled() {
        return this.withAutoDeployEnabled(true);
    }

    public class BuildEnvVarsNested<N>
    extends EnvFluent<BuildEnvVarsNested<N>>
    implements Nested<N> {
        EnvBuilder builder;
        int index;

        BuildEnvVarsNested(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder((EnvFluent)this, item);
        }

        public N and() {
            return (N)S2iBuildConfigFluent.this.setToBuildEnvVars(this.index, (Env)this.builder.build());
        }

        public N endBuildEnvVar() {
            return this.and();
        }
    }
}

