/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.config;

import io.dekorate.servicebinding.config.EditableServiceConfig;
import io.dekorate.servicebinding.config.ServiceConfig;
import io.dekorate.servicebinding.config.ServiceConfigFluent;
import io.dekorate.servicebinding.config.ServiceConfigFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class ServiceConfigBuilder
extends ServiceConfigFluentImpl<ServiceConfigBuilder>
implements VisitableBuilder<ServiceConfig, ServiceConfigBuilder> {
    ServiceConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceConfigBuilder() {
        this(false);
    }

    public ServiceConfigBuilder(Boolean validationEnabled) {
        this(new ServiceConfig(), validationEnabled);
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceConfig(), validationEnabled);
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent, ServiceConfig instance) {
        this(fluent, instance, false);
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent, ServiceConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProject(instance.getProject());
        fluent.withAttributes(instance.getAttributes());
        fluent.withGroup(instance.getGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withVersion(instance.getVersion());
        fluent.withId(instance.getId());
        fluent.withNamespace(instance.getNamespace());
        fluent.withEnvVarPrefix(instance.getEnvVarPrefix());
        this.validationEnabled = validationEnabled;
    }

    public ServiceConfigBuilder(ServiceConfig instance) {
        this(instance, (Boolean)false);
    }

    public ServiceConfigBuilder(ServiceConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withId(instance.getId());
        this.withNamespace(instance.getNamespace());
        this.withEnvVarPrefix(instance.getEnvVarPrefix());
        this.validationEnabled = validationEnabled;
    }

    public EditableServiceConfig build() {
        EditableServiceConfig buildable = new EditableServiceConfig(this.fluent.getProject(), this.fluent.getAttributes(), this.fluent.getGroup(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getVersion(), this.fluent.getId(), this.fluent.getNamespace(), this.fluent.getEnvVarPrefix());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceConfigBuilder that = (ServiceConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

